/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.inventory;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ActionRevertInventoryComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private TitledItem<SearchTextField2<StoreLight>> selectedStore;
    private TitledItem<CheckBox> revertAsCounting;
    private MultiLineTextLabel label;
    protected Node<InventoryLight> node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;

    public ActionRevertInventoryComponent(Node<InventoryLight> node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    protected void installPort() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.selectedStore = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), "Store", TitledItem.TitledItemOrientation.NORTH);
        this.revertAsCounting = new TitledItem<CheckBox>(new CheckBox(), "Revert as Counting", TitledItem.TitledItemOrientation.EAST);
        this.viewPort.add(this.selectedStore);
        this.viewPort.add(this.revertAsCounting);
        this.label.setText("Revert Inventory (should only be done by Administrator)");
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
    }

    @Override
    public String getTitleString() {
        return "Revert Inventory";
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        this.selectedStore.kill();
        this.selectedStore = null;
        this.revertAsCounting.kill();
        this.revertAsCounting = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.currentModel.getView().revalidate();
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryLight o = (InventoryLight)ActionRevertInventoryComponent.this.node.getValue(InventoryLight.class);
                StoreLight store = (StoreLight)((SearchTextField2)ActionRevertInventoryComponent.this.selectedStore.getElement()).getNode().getValue();
                boolean checked = ((CheckBox)ActionRevertInventoryComponent.this.revertAsCounting.getElement()).isChecked();
                System.out.println("found store to revert inventory on " + store);
                ((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).revert(new InventoryReference(o.getId()), (StoreReference)store, Boolean.valueOf(checked));
                return ActionRevertInventoryComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionRevertInventoryComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return "Revert";
    }

    @Override
    protected String getFinishedText() {
        return "Successfully reverted";
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionRevertInventoryComponent.this.scrollPane.getWidth() - ActionRevertInventoryComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionRevertInventoryComponent.this.label.getPreferredSize().getHeight();
            h += ActionRevertInventoryComponent.this.border;
            h = (int)((double)h + ActionRevertInventoryComponent.this.selectedStore.getPreferredSize().getHeight());
            h += ActionRevertInventoryComponent.this.border;
            h = (int)((double)h + ActionRevertInventoryComponent.this.revertAsCounting.getPreferredSize().getHeight());
            return new Dimension(w, h += ActionRevertInventoryComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionRevertInventoryComponent.this.label.setLocation(0, 0);
            ActionRevertInventoryComponent.this.label.setSize(parent.getWidth(), (int)ActionRevertInventoryComponent.this.label.getPreferredSize().getHeight());
            ActionRevertInventoryComponent.this.selectedStore.setLocation(0, ActionRevertInventoryComponent.this.label.getY() + ActionRevertInventoryComponent.this.label.getHeight() + ActionRevertInventoryComponent.this.border);
            ActionRevertInventoryComponent.this.selectedStore.setSize(parent.getWidth() - 2 * ActionRevertInventoryComponent.this.border, (int)ActionRevertInventoryComponent.this.selectedStore.getPreferredSize().getHeight());
            ActionRevertInventoryComponent.this.revertAsCounting.setLocation(0, ActionRevertInventoryComponent.this.selectedStore.getY() + ActionRevertInventoryComponent.this.selectedStore.getHeight() + ActionRevertInventoryComponent.this.border);
            ActionRevertInventoryComponent.this.revertAsCounting.setSize(ActionRevertInventoryComponent.this.revertAsCounting.getPreferredSize());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionRevertInventoryComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionRevertInventoryComponent.this.layoutInheritedComponents(parent);
            ActionRevertInventoryComponent.this.scrollPane.setLocation(ActionRevertInventoryComponent.this.border, ActionRevertInventoryComponent.this.border);
            ActionRevertInventoryComponent.this.scrollPane.setSize(parent.getWidth() - ActionRevertInventoryComponent.this.border, parent.getHeight() - ActionRevertInventoryComponent.this.border);
        }
    }
}

