/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.migros.order;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.exchange.migros.MigrosExchangeServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderImportReference;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ActionCreateOrderAvisMigrosComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private MultiLineTextLabel label;
    protected Node<MigrosDataComplete> node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;
    protected boolean emptyPositionShown;

    public ActionCreateOrderAvisMigrosComponent(Node<MigrosDataComplete> node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    protected void installPort() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.label.setText("");
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
        this.emptyPositionShown = true;
    }

    @Override
    public String getTitleString() {
        return "Migros EDI";
    }

    @Override
    public String getTitleValue() {
        return "Send Order Avis";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.currentModel.getView().revalidate();
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MigrosDataComplete data = (MigrosDataComplete)ActionCreateOrderAvisMigrosComponent.this.node.getValue(MigrosDataComplete.class);
                data = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).generateOrderAvis(new MigrosOrderImportReference(data.getId())).getValue();
                ActionCreateOrderAvisMigrosComponent.this.node.removeExistingValues();
                ActionCreateOrderAvisMigrosComponent.this.node.setValue((Object)data, 0L);
                ActionCreateOrderAvisMigrosComponent.this.node.updateNode();
                return ActionCreateOrderAvisMigrosComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionCreateOrderAvisMigrosComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return "Send Order Avis";
    }

    @Override
    protected String getFinishedText() {
        return "Order Avis sent";
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionCreateOrderAvisMigrosComponent.this.scrollPane.getWidth() - ActionCreateOrderAvisMigrosComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionCreateOrderAvisMigrosComponent.this.label.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCreateOrderAvisMigrosComponent.this.label.setLocation(0, 0);
            ActionCreateOrderAvisMigrosComponent.this.label.setSize(parent.getWidth(), (int)ActionCreateOrderAvisMigrosComponent.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionCreateOrderAvisMigrosComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCreateOrderAvisMigrosComponent.this.layoutInheritedComponents(parent);
            ActionCreateOrderAvisMigrosComponent.this.scrollPane.setLocation(ActionCreateOrderAvisMigrosComponent.this.border, ActionCreateOrderAvisMigrosComponent.this.border);
            ActionCreateOrderAvisMigrosComponent.this.scrollPane.setSize(parent.getWidth() - ActionCreateOrderAvisMigrosComponent.this.border, parent.getHeight() - ActionCreateOrderAvisMigrosComponent.this.border);
        }
    }
}

