/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.purchase.cancel;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ActionCancelPOOrderComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private MultiLineTextLabel label;
    protected Node node;
    private Color defaultBackground;
    protected UserReference currentUser;
    protected RowModel currentModel;
    protected boolean emptyPositionShown;
    protected boolean canBeClosed;

    public ActionCancelPOOrderComponent(Node node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.ensureAnimation();
        this.loadComplete();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentModel != null) {
            this.currentModel.mergeNode(this.node, true);
        }
        super.remoteObjectLoaded(node);
    }

    protected void loadComplete() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderLight l = (PurchaseOrderLight)ActionCancelPOOrderComponent.this.node.getValue(PurchaseOrderLight.class);
                PurchaseOrderComplete c = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(l.getId())).getValue();
                ActionCancelPOOrderComponent.this.canBeClosed = ActionCancelPOOrderComponent.this.isOrderClosable(c);
                ActionCancelPOOrderComponent.this.node.removeExistingValues();
                ActionCancelPOOrderComponent.this.node.setValue((Object)c, 0L);
                return ActionCancelPOOrderComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionCancelPOOrderComponent.this.installPort();
                    }

                    public void errorOccurred(ClientException exception) {
                        ActionCancelPOOrderComponent.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected boolean isOrderClosable(PurchaseOrderComplete c) {
        switch (c.getState()) {
            case CANCELLED: 
            case CLOSED: 
            case DELIVERED: 
            case PENDING: 
            case RECEIVED: {
                return false;
            }
            case PLACED: {
                return true;
            }
        }
        return false;
    }

    protected Class getGettingClass() {
        return PurchaseOrderComplete.class;
    }

    protected void installPort() {
        this.removeAnimation(false);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.label.setText(this.getText4Order(this.node.getValue(this.getGettingClass())));
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
        this.emptyPositionShown = true;
    }

    public String getEnsureText() {
        return Words.ARE_YOU_SURE_TO_CANCEL_ORDER;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        this.removeInheritedComponents();
        if (this.emptyPositionShown && this.canBeClosed) {
            this.showMessage(this.getEnsureText());
            this.emptyPositionShown = false;
            this.popup.setCancelButtonText(Words.NO_ANSWER);
            this.popup.setOkButtonText(Words.YES);
            return;
        }
        if (!this.canBeClosed) {
            this.popup.hidePopUp(new Object[0]);
        }
        super.enterPressed(isOK);
    }

    protected String getText4Order(Object order) {
        if (!this.canBeClosed) {
            String t = Words.ORDER_WITH_RECEIPTS_CAN_NOT_BE_CANCELLED;
            return t;
        }
        String t = Words.OPEN_POSITION_TITLE;
        Converter c = ConverterRegistry.getConverter(BasicArticleConverter.class);
        for (PurchaseOrderPositionComplete pos : ((PurchaseOrderComplete)order).getOrderPositions()) {
            if (pos.getState() == OrderStateE.CLOSED || pos.getState() == OrderStateE.CANCELLED) continue;
            t = t + Phrase.getPhrase((String)Phrase.ARTICLE_LIST, (Object[])new Object[]{c.convert((Object)pos.getArticle(), null, new Object[0])});
        }
        t = t + "</html>";
        return t;
    }

    public void setUser(UserReference u) {
        this.currentUser = u;
    }

    @Override
    public String getTitleString() {
        return null;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
        }
        this.label = null;
        if (this.viewPort != null && this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        if (this.scrollPane != null) {
            this.scrollPane.kill();
        }
        this.scrollPane = null;
        if (this.currentModel != null && this.currentModel.getView() != null) {
            this.currentModel.getView().revalidate();
        }
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionCancelPOOrderComponent.this.canBeClosed) {
                    PurchaseOrderComplete o = (PurchaseOrderComplete)ActionCancelPOOrderComponent.this.node.getValue(PurchaseOrderComplete.class);
                    PurchaseOrderComplete no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).cancelPurchaseOrder(new PurchaseOrderReference(o.getId())).getValue();
                    ActionCancelPOOrderComponent.this.node.removeExistingValues();
                    ActionCancelPOOrderComponent.this.node.setValue((Object)no, 0L);
                    ActionCancelPOOrderComponent.this.node.updateNode();
                }
                return ActionCancelPOOrderComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionCancelPOOrderComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return Words.CANCEL_ORDER;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionCancelPOOrderComponent.this.scrollPane.getWidth() - ActionCancelPOOrderComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionCancelPOOrderComponent.this.label.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCancelPOOrderComponent.this.label.setLocation(0, 0);
            ActionCancelPOOrderComponent.this.label.setSize(parent.getWidth(), (int)ActionCancelPOOrderComponent.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionCancelPOOrderComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCancelPOOrderComponent.this.layoutInheritedComponents(parent);
            ActionCancelPOOrderComponent.this.scrollPane.setLocation(ActionCancelPOOrderComponent.this.border, ActionCancelPOOrderComponent.this.border);
            ActionCancelPOOrderComponent.this.scrollPane.setSize(parent.getWidth() - ActionCancelPOOrderComponent.this.border, parent.getHeight() - ActionCancelPOOrderComponent.this.border);
        }
    }
}

