/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.purchasepreview.open;

import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.PurchaseOrderToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ActionOpenPreviewOrdersComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel messageLabel;
    private TitledItem<CheckBox> sendToSupplier;
    private Node<ManualPurchaseOrderPreviewLight> node;
    private RowModel<ManualPurchaseOrderPreviewLight> model;

    public ActionOpenPreviewOrdersComponent(Node<ManualPurchaseOrderPreviewLight> node, RowModel<ManualPurchaseOrderPreviewLight> model) {
        super(false, false);
        this.node = node;
        this.model = model;
        this.messageLabel = new MultiLineTextLabel(Words.CREATE_ORDERS_FROM_PREVIEW);
        this.sendToSupplier = new TitledItem<CheckBox>(new CheckBox(), Words.SEND_PURCHASE_ORDER_TO_SUPPLIER, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.sendToSupplier);
        this.getViewContainer().add(this.messageLabel);
    }

    @Override
    protected String getProgressText() {
        return Words.CREATE_ORDERS;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionOpenPreviewOrdersComponent.this.node != null) {
                    PurchaseOrderComplete order;
                    ManualPurchaseOrderPreviewLight orderPreviews = (ManualPurchaseOrderPreviewLight)ActionOpenPreviewOrdersComponent.this.node.getValue();
                    ManualPurchaseOrderPreviewComplete orderPreviewComplete = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getManualPurchaseOrderPreview((ManualPurchaseOrderPreviewReference)orderPreviews).getValue();
                    ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                    for (PurchaseOrderPreviewComplete previewComplete : orderPreviewComplete.getOrders()) {
                        order = PurchaseOrderToolkit.convertPurchaseOrderPreview(previewComplete);
                        order.getEligibleLocations().add(orderPreviews.getOrderLocation());
                        for (PurchaseOrderPositionComplete position : order.getOrderPositions()) {
                            try {
                                BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(position.getArticle().getId())).getValue();
                                SupplierConditionBaseComplete supplier = basicArticle.getSupplier((SupplierReference)order.getSupplier());
                                List conditions = ((SupplierConditionCategoryComplete)supplier.getSupplierConditionCategory().get(0)).getConditions();
                                SupplierConditionComplete selectedCondition = null;
                                for (SupplierConditionComplete condition : conditions) {
                                    if (!condition.getValidityPeriod().within(order.getOrderDate()).booleanValue()) continue;
                                    selectedCondition = condition;
                                    position.setSupplierCondition(CopyTemplateToolkit.copySupplierCondition(condition));
                                }
                                if (position.getSupplierCondition() == null) {
                                    selectedCondition = (SupplierConditionComplete)conditions.get(conditions.size() - 1);
                                }
                                PriceAndUnitComplete articlePrice = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice(new BasicArticleReference(position.getArticle().getId()), new SupplierReference(order.getSupplier().getId()), new DateWrapper(order.getOrderDate()), new QuantityComplete(Double.valueOf(position.getQuantity().getAmount().doubleValue()), position.getQuantity().getUnit()), order.getUseTaxZone(), order.getTaxZone(), selectedCondition);
                                position.setSupplierPrice(articlePrice.getPrice());
                                position.setPriceUnit(articlePrice.getUnit());
                            }
                            catch (Exception e) {
                                warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                            }
                        }
                    }
                    if (warnings.isEmpty()) {
                        for (PurchaseOrderPreviewComplete previewComplete : orderPreviewComplete.getOrders()) {
                            order = PurchaseOrderToolkit.convertPurchaseOrderPreview(previewComplete);
                            order.getEligibleLocations().add(orderPreviewComplete.getOrderLocation());
                            PurchaseOrderComplete purchaseOrder = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createPurchaseOrder(order).getValue();
                            if (!((CheckBox)ActionOpenPreviewOrdersComponent.this.sendToSupplier.getElement()).isChecked()) continue;
                            SendPurchaseOrderAction action = new SendPurchaseOrderAction();
                            action.performAction(ActionOpenPreviewOrdersComponent.this, null, purchaseOrder);
                        }
                        orderPreviewComplete.setOrderState(PurchaseOrderPreviewStateE.CREATED);
                        orderPreviewComplete.setOrdersCreatedAt(new Timestamp(System.currentTimeMillis()));
                        orderPreviewComplete.setOrdersCreatedUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        orderPreviewComplete = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updateManualPurchaseOrderPreview(orderPreviewComplete).getValue();
                        ActionOpenPreviewOrdersComponent.this.node.removeExistingValues();
                        ActionOpenPreviewOrdersComponent.this.node.setValue((Object)orderPreviewComplete, 0L);
                        ActionOpenPreviewOrdersComponent.this.node.updateNode();
                    } else {
                        InnerPopupFactory.showErrorDialog(warnings, Words.UNABLE_TO_CREATE_ORDERS, (Component)ActionOpenPreviewOrdersComponent.this);
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionOpenPreviewOrdersComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.model != null) {
            this.model.mergeNode(this.node, true);
        }
        super.remoteObjectLoaded(node);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.messageLabel.setVisible(false);
        this.sendToSupplier.setVisible(false);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ActionOpenPreviewOrdersComponent.this.getInheritedComponentsHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionOpenPreviewOrdersComponent.this.layoutInheritedComponents(parent);
            ActionOpenPreviewOrdersComponent.this.messageLabel.setLocation(ActionOpenPreviewOrdersComponent.this.border, ActionOpenPreviewOrdersComponent.this.border + y);
            ActionOpenPreviewOrdersComponent.this.messageLabel.setSize(ActionOpenPreviewOrdersComponent.this.messageLabel.getPreferredSize());
            ActionOpenPreviewOrdersComponent.this.sendToSupplier.setLocation(ActionOpenPreviewOrdersComponent.this.border, ActionOpenPreviewOrdersComponent.this.messageLabel.getY() + ActionOpenPreviewOrdersComponent.this.messageLabel.getHeight() + ActionOpenPreviewOrdersComponent.this.border);
            ActionOpenPreviewOrdersComponent.this.sendToSupplier.setSize(ActionOpenPreviewOrdersComponent.this.sendToSupplier.getPreferredSize());
        }
    }
}

