/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.retail.invoice.close;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionCloseInvoiceComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel field;
    private Node node;
    private final RowPanel<FlightLight> view;

    public ActionCloseInvoiceComponent(Node node, RowModel model, RowPanel<FlightLight> view) {
        super(false, false);
        this.node = node;
        this.view = view;
        this.field = new MultiLineTextLabel(Words.CLOSE_INVOICE);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.field);
    }

    @Override
    protected String getProgressText() {
        return Words.CLOSE;
    }

    @Override
    protected String getFinishedText() {
        return Words.CLOSED;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionCloseInvoiceComponent.this.node != null) {
                    FlightLight flight = (FlightLight)ActionCloseInvoiceComponent.this.node.getValue();
                    InvoiceLight invoiceByFlight = (InvoiceLight)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoiceForFlight(new FlightReference(flight.getId())).getValue();
                    if (invoiceByFlight.getState() != InvoiceStateE.CLOSED && invoiceByFlight.getState() != InvoiceStateE.CANCELLED) {
                        InvoiceComplete invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(invoiceByFlight.getId())).getValue();
                        invoice.setState(InvoiceStateE.CLOSED);
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(invoice).getValue();
                        flight = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightLight(new FlightReference(flight.getId())).getValue();
                        ActionCloseInvoiceComponent.this.node.removeExistingValues();
                        ActionCloseInvoiceComponent.this.node.setValue((Object)flight, 0L);
                        ActionCloseInvoiceComponent.this.node.updateNode();
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionCloseInvoiceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.view.refreshCells();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.field.setVisible(false);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ActionCloseInvoiceComponent.this.getInheritedComponentsHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionCloseInvoiceComponent.this.layoutInheritedComponents(parent);
            ActionCloseInvoiceComponent.this.field.setLocation(0, 0);
            ActionCloseInvoiceComponent.this.field.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

