/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.sageimport;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.sageimport.SageImportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.sage.SageImportComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.dtos.sage.SageImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ActionResolveSageImportComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private MultiLineTextLabel label;
    protected Node<SageImportLight> node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;
    protected boolean emptyPositionShown;

    public ActionResolveSageImportComponent(Node<SageImportLight> node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    protected void installPort() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.label.setText(Words.RESOLVE);
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
        this.emptyPositionShown = true;
    }

    @Override
    public String getTitleString() {
        return Words.RESOLVE;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.currentModel.getView().revalidate();
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SageImportLight o = (SageImportLight)ActionResolveSageImportComponent.this.node.getValue(SageImportLight.class);
                ArrayList<SageImportReference> data = new ArrayList<SageImportReference>();
                data.add(new SageImportReference(o.getId()));
                ((SageImportServiceManager)ServiceManagerRegistry.getService(SageImportServiceManager.class)).resolveSageImport(new ListWrapper(data));
                SageImportComplete no = (SageImportComplete)((SageImportServiceManager)ServiceManagerRegistry.getService(SageImportServiceManager.class)).getSageImport(new SageImportReference(o.getId())).getValue();
                ActionResolveSageImportComponent.this.node.removeExistingValues();
                ActionResolveSageImportComponent.this.node.setValue((Object)no, 0L);
                ActionResolveSageImportComponent.this.node.updateNode();
                return ActionResolveSageImportComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionResolveSageImportComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return Words.RESOLVE;
    }

    @Override
    protected String getFinishedText() {
        return Words.RESOLVED;
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionResolveSageImportComponent.this.scrollPane.getWidth() - ActionResolveSageImportComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionResolveSageImportComponent.this.label.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionResolveSageImportComponent.this.label.setLocation(0, 0);
            ActionResolveSageImportComponent.this.label.setSize(parent.getWidth(), (int)ActionResolveSageImportComponent.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionResolveSageImportComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionResolveSageImportComponent.this.layoutInheritedComponents(parent);
            ActionResolveSageImportComponent.this.scrollPane.setLocation(ActionResolveSageImportComponent.this.border, ActionResolveSageImportComponent.this.border);
            ActionResolveSageImportComponent.this.scrollPane.setSize(parent.getWidth() - ActionResolveSageImportComponent.this.border, parent.getHeight() - ActionResolveSageImportComponent.this.border);
        }
    }
}

