/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.store.productchargecount;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.InventoryProductChargeCountTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProductChargeCountActionComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StoreLight> storeNode;
    private InventoryProductChargeCountTable countTable;
    private TextButton importFromExcel;

    public ProductChargeCountActionComponent(Node<StoreLight> dto) {
        super(false, false, false, false, null);
        this.storeNode = dto;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.countTable);
        CheckedListAdder.addToList(focusList, this.importFromExcel);
        return focusList;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.countTable = new InventoryProductChargeCountTable(this.popup);
        this.importFromExcel = new TextButton("Import from Excel");
        this.importFromExcel.addButtonListener((source, x, y) -> this.importFile());
        this.getViewContainer().add(this.countTable);
        this.getViewContainer().add(this.importFromExcel);
    }

    private void importFile() {
        this.setEnabled(false);
        final File file = FileChooserUtil.loadFile();
        if (file != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    List rows = ExcelToolkit.readRows((File)file);
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    Node node = ProductChargeCountActionComponent.this.countTable.getModel().getNode();
                    for (ExcelRow row : rows) {
                        ProductCountTransactionComplete counting = new ProductCountTransactionComplete();
                        counting.setClientOId(Long.valueOf(ADTO.getNextId()));
                        counting.setOriginStore(((StoreLight)ProductChargeCountActionComponent.this.storeNode.getValue()).getDefaultStorePosition());
                        Integer pNumber = ExcelToolkit.readAsInteger((ExcelRow)row, (int)0);
                        Integer pCount = ExcelToolkit.readAsInteger((ExcelRow)row, (int)2);
                        counting.setQuantity(new StoreQuantityComplete(Long.valueOf(pCount.longValue()), settings.getPieceUnit()));
                        ProductSearchConfiguration pSearch = new ProductSearchConfiguration();
                        pSearch.setNumber(pNumber);
                        pSearch.setName(null);
                        SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)pSearch);
                        ProductComplete product = (ProductComplete)result.getSingleResult();
                        counting.setProduct(product);
                        node.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)counting, true, false), 0L);
                    }
                    return new ViewNode("");
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ProductChargeCountActionComponent.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ProductChargeCountActionComponent.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ProductChargeCountActionComponent.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            InnerPopupFactory.showErrorDialog("No File selected", (Component)this);
        }
    }

    @Override
    protected String getProgressText() {
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.storeNode.getValue()).getCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node node = ProductChargeCountActionComponent.this.countTable.getModel().getNode();
                InventoryReference inventoryInProgress = ((StoreLight)ProductChargeCountActionComponent.this.storeNode.getValue()).getInventoryInProgress();
                UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                Iterator it = node.getFailSafeChildIterator();
                ArrayList<String> warnings = new ArrayList<String>();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    next.commitThis();
                    ProductCountTransactionComplete transaction = (ProductCountTransactionComplete)next.getValue();
                    if (transaction == null || transaction.getProduct() == null) continue;
                    transaction.setTransactionDate(new Timestamp(System.currentTimeMillis()));
                    transaction.setInventory(inventoryInProgress);
                    transaction.setMobileAppCount(Boolean.valueOf(false));
                    transaction.setUser((UserLight)currentUser);
                    transaction.setOriginStore(((StoreLight)ProductChargeCountActionComponent.this.storeNode.getValue()).getDefaultStorePosition());
                    try {
                        ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).countProductPositionBased(transaction);
                    }
                    catch (Exception e) {
                        warnings.add(e.getMessage());
                    }
                }
                if (!warnings.isEmpty()) {
                    String text = "<ul>";
                    for (String warning : warnings) {
                        text = text + "<li>" + warning + "</li><br/>";
                    }
                    text = text + "</ul>";
                    throw new ClientServerCallException(text);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductChargeCountActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO(this.storeNode.getValue(), false, true);
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ProductChargeCountActionComponent.this.layoutInheritedComponents(parent);
            ProductChargeCountActionComponent.this.countTable.setLocation(0, y);
            ProductChargeCountActionComponent.this.countTable.setSize(parent.getWidth() - 4, (int)((double)parent.getHeight() - ((double)y + ProductChargeCountActionComponent.this.importFromExcel.getPreferredSize().getHeight() + (double)(ProductChargeCountActionComponent.this.border * 2))));
            ProductChargeCountActionComponent.this.importFromExcel.setLocation(ProductChargeCountActionComponent.this.border, ProductChargeCountActionComponent.this.countTable.getY() + ProductChargeCountActionComponent.this.countTable.getHeight() + ProductChargeCountActionComponent.this.border);
            ProductChargeCountActionComponent.this.importFromExcel.setSize(ProductChargeCountActionComponent.this.importFromExcel.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ProductChargeCountActionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

