/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.stowinglist.openstw;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.tables.StowingListVariantTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StowingListAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionOpenStowingListSTWComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private TextLabel titleText;
    private StowingListVariantTable table;
    private LoadingAnimation loadingAnimation;
    private Node<StowingListTemplateComplete> node;
    private final MainFrame mainFrame;

    public ActionOpenStowingListSTWComponent(Node<StowingListTemplateComplete> node, RowModel model, MainFrame mainFrame, InnerPopUp2 pop) {
        super(false, false);
        this.node = node;
        this.mainFrame = mainFrame;
        this.titleText = new TextLabel(Words.SELECT_STOWING_LIST_VARIANT);
        this.table = new StowingListVariantTable(mainFrame, pop, StowingListAccess.TOOL_STOWING_LIST_TEMPLATE_STOWING_EDITOR_REAL);
        this.loadingAnimation = new LoadingAnimation();
        this.loadingAnimation.getFader().setPermanent(true);
        this.loadingAnimation.getFader().setProgress(0.0f);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.loadingAnimation);
        this.getViewContainer().add(this.titleText);
        this.getViewContainer().add(this.table);
        this.generateStowingListVariantList(node);
        this.showAnimation();
    }

    private void showAnimation() {
        this.loadingAnimation.setProgress(1.0f);
        this.getViewContainer().add(this.loadingAnimation);
    }

    private void hideAnimation() {
        this.loadingAnimation.fadeOut(false);
    }

    private void generateStowingListVariantList(final Node<StowingListTemplateComplete> node) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ViewNode returnNode = new ViewNode("");
                StowingListTemplateComplete value = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                List variants = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(value.getVariants())).getList();
                for (StowingListTemplateVariantLight variant : variants) {
                    Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)variant, false, true);
                    returnNode.addChild(node4DTO, 0L);
                }
                return returnNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionOpenStowingListSTWComponent.this.table.setNode(node);
                        ActionOpenStowingListSTWComponent.this.setEnabled(true);
                        ActionOpenStowingListSTWComponent.this.hideAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ActionOpenStowingListSTWComponent.this);
                        ActionOpenStowingListSTWComponent.this.popup.hidePopUp(new Object[0]);
                        ActionOpenStowingListSTWComponent.this.setEnabled(true);
                        ActionOpenStowingListSTWComponent.this.hideAnimation();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return Words.STOWING_LIST;
    }

    @Override
    protected String getFinishedText() {
        return Words.STOWING_LIST;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionOpenStowingListSTWComponent.this.node != null) {
                    // empty if block
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionOpenStowingListSTWComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.titleText.setVisible(false);
        this.table.setVisible(false);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ActionOpenStowingListSTWComponent.this.getInheritedComponentsHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionOpenStowingListSTWComponent.this.layoutInheritedComponents(parent);
            ActionOpenStowingListSTWComponent.this.titleText.setLocation(0, 0);
            ActionOpenStowingListSTWComponent.this.titleText.setSize(parent.getWidth(), (int)ActionOpenStowingListSTWComponent.this.titleText.getPreferredSize().getHeight());
            ActionOpenStowingListSTWComponent.this.table.setLocation(0, ActionOpenStowingListSTWComponent.this.titleText.getY() + ActionOpenStowingListSTWComponent.this.titleText.getHeight() + ActionOpenStowingListSTWComponent.this.border);
            ActionOpenStowingListSTWComponent.this.table.setSize(parent.getWidth(), parent.getHeight() - ActionOpenStowingListSTWComponent.this.table.getY());
        }
    }
}

