/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.user.apply;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionApplyUserComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    protected Node<UserLight> node;
    private RowModel<UserLight> currentModel;
    private TitledItem<SearchTextField2<UserLight>> userTopApplyTo;

    public ActionApplyUserComponent(Node<UserLight> node, RowModel<UserLight> model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.createComponents();
        this.setLayout(new Layout());
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.userTopApplyTo = new TitledItem<SearchTextField2<UserLight>>(SearchTextField2Factory.getUserSearchField(true, new DTOProxyNode()), "User to copy access from", TitledItem.TitledItemOrientation.NORTH);
        this.add(this.userTopApplyTo);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> list = super.getFocusComponents();
        CheckedListAdder.addToList(list, this.userTopApplyTo);
        return list;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentModel != null) {
            this.currentModel.mergeNode(this.node, true);
        }
        super.remoteObjectLoaded(node);
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.userTopApplyTo.getElement().isItemSelected()) {
            this.userTopApplyTo.getElement().setInvalid();
            return;
        }
        this.removeInheritedComponents();
        super.enterPressed(isOK);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.userTopApplyTo.setVisible(true);
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.setEnabled(true);
        this.popup.setEnabled(true);
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.userTopApplyTo.kill();
        this.userTopApplyTo = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserLight l = (UserLight)ActionApplyUserComponent.this.node.getValue(UserLight.class);
                UserReference r = new UserReference(((UserLight)((SearchTextField2)ActionApplyUserComponent.this.userTopApplyTo.getElement()).getNode().getValue()).getId());
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).applyUser(l, r);
                ActionApplyUserComponent.this.currentModel.getView().refreshCells();
                ActionApplyUserComponent.this.currentModel.getView().revalidate();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionApplyUserComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return Words.COPY_USER;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionApplyUserComponent.this.userTopApplyTo.setLocation(5, 5);
            ActionApplyUserComponent.this.userTopApplyTo.setSize(parent.getWidth() - 10, (int)ActionApplyUserComponent.this.userTopApplyTo.getPreferredSize().getHeight());
        }
    }
}

