/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote.currency;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;

public class AnalysisArticleByCurrencyComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public AnalysisArticleByCurrencyComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "validityDate"));
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_USAGE;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getArticleByCurrencyReport(new ListWrapper(), new TimestampWrapper(date.getTime())).getValue();
        return file;
    }
}

