/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote.storeinfo;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.SearchTextField2AnalysisItem;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisArticleStoreInfoSheetsComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference> {
    private static Logger log = LoggerFactory.getLogger(AnalysisArticleStoreInfoSheetsComponent.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> onlyForArticlesWithStock;
    private TitledItem<SearchTextField2<StoreLight>> storeSearch;

    public AnalysisArticleStoreInfoSheetsComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.dueDate.setVisible(false);
        this.onlyForArticlesWithStock.setVisible(false);
        this.storeSearch.setVisible(false);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.dueDate.setVisible(true);
        this.onlyForArticlesWithStock.setVisible(true);
        this.storeSearch.setVisible(true);
    }

    @Override
    public void addOptionItems() {
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.VALIDITY_FROM, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
        this.onlyForArticlesWithStock = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_FOR_ARTICLE_WITH_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.onlyForArticlesWithStock, "onlyForArticleWithStock"));
        this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new SearchTextField2AnalysisItem(this.storeSearch, "storeSearch"));
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_STORE_INFO_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List articles = this.loadItemReferences();
        ReportFileComplete selectedReport = null;
        selectedReport = this.getSelectedReport();
        Date date = (Date)this.dueDate.getElement().getNode().getValue();
        StoreLight storeLight = (StoreLight)this.storeSearch.getElement().getNode().getValue();
        StoreLight storeReference = storeLight != null ? storeLight : new StoreReference();
        PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getArticleStoreInfoSheets(new ListWrapper(articles), selectedReport, new DateWrapper(date), Boolean.valueOf(this.onlyForArticlesWithStock.getElement().isChecked()), (StoreReference)storeReference).getValue();
        return file;
    }
}

