/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote.supplierspecs;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.SupplierSpecificationReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.io.File;
import java.sql.Date;
import java.util.List;

public class AnalysisArticleSupplierSpecsComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validFrom;

    public AnalysisArticleSupplierSpecsComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.validFrom = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.VALIDITY_FROM, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validFrom, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_SUPPLIER_SPECIFICATIONS;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        java.util.Date d = this.validFrom.getElement().getSelectedDate();
        Date date = new Date(d.getTime());
        SupplierSpecificationReportConfiguration config = new SupplierSpecificationReportConfiguration();
        config.setArticles(s);
        config.setFromDate(date);
        List file = ((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getArticleSupplierSpecifications(config).getList();
        if (file.isEmpty()) {
            this.isError = true;
            this.errorMSG = "No Supplier Specifications found";
        }
        for (PegasusFileComplete f : file) {
            try {
                File df = FileTransferUtil.download((PegasusFileComplete)f, (FileTransferListener[])new FileTransferListener[0]);
                if (!df.getName().toLowerCase().endsWith("pdf")) continue;
                PrintPopupToolkit.previewFile(df);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

