/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.customs.transaction;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.CustomsTransactionAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class CustomsTransactionsAnalysisComponent
extends AsynchronusAnalysisPopupInsert<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser period;
    private TitledItem<CheckBox> includeOnlyMainStore;
    private TitledItem<CheckBox> showMovementStoresSplit;
    private TitledItem<CheckBox> includeIrregularity;
    private TitledItem<CheckBox> includeFlightData;
    private TitledItem<CheckBox> excludeFlightTransactions;

    public CustomsTransactionsAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        TimestampPeriodComplete p = new TimestampPeriodComplete();
        p.setStartTime(new Timestamp(System.currentTimeMillis()));
        p.setEndTime(new Timestamp(System.currentTimeMillis()));
        this.period = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false));
        this.includeOnlyMainStore = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_MAIN_STORES, TitledItem.TitledItemOrientation.EAST);
        this.showMovementStoresSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_MOVEMENT_STORES_SPLITTED, TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeFlightData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_FLIGHT_DATA, TitledItem.TitledItemOrientation.EAST);
        this.excludeFlightTransactions = new TitledItem<CheckBox>(new CheckBox(), Words.EXCLUDE_FLIGHT_TRANSACTIONS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateTimePeriodEditorAnalysisItem(this.period, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeOnlyMainStore, "onlyMainStore"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.showMovementStoresSplit, "showMovementStoresSplit"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeIrregularity, "includeIrregularity"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeFlightData, "includeFlightData"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.excludeFlightTransactions, "excludeFlightTransactions"));
    }

    @Override
    protected boolean includeCSVExportFormat() {
        return true;
    }

    @Override
    protected boolean includePDFExportFormat() {
        return false;
    }

    @Override
    public boolean chooseExportFormat() {
        return true;
    }

    @Override
    public String getFileEnding() {
        return this.csvRadioButton != null && ((RadioButton)this.csvRadioButton.getElement()).isChecked() ? ".txt" : ".xlsx";
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        CustomsTransactionAnalysisReportConfiguration conf = new CustomsTransactionAnalysisReportConfiguration();
        conf.setIncludeOnlyMainStores(this.includeOnlyMainStore.getElement().isChecked());
        conf.setSplitStoreForMovement(this.showMovementStoresSplit.getElement().isChecked());
        conf.setIncludeIrregularity(this.includeIrregularity.getElement().isChecked());
        conf.setIncludeFlightData(this.includeFlightData.getElement().isChecked());
        conf.setExcludeFlightTransactions(this.excludeFlightTransactions.getElement().isChecked());
        conf.setOutputFormat(((RadioButton)this.excelRadioButton.getElement()).isChecked() ? ReportingOutputFormatE.XLSX : ReportingOutputFormatE.CSV);
        TimestampPeriodComplete p = this.period.getTimePeriod();
        conf.setPeriodStartDate(p.getStartTime());
        conf.setPeriodEndDate(p.getEndTime());
        return conf;
    }
}

