/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.forecast;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimeChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class ArticleForecastAnalysisComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateTimeChooser> dateTimeChooser;
    private TitledItem<CheckBox> includeInventoryData;
    private TitledItem<CheckBox> includeStockData;

    public ArticleForecastAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        this.dateTimeChooser = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateTimeChooser.getElement().getNode().addNodeListener((NodeListener)this);
        this.includeInventoryData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_INVENTORY_DATA, TitledItem.TitledItemOrientation.EAST);
        this.includeStockData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOCK_DATA, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateTimeChooserAnalysisItem(this.dateTimeChooser, "dueDate"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeInventoryData, "inventoryData"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStockData, "stockData"));
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_FORECAST;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        boolean iInventory = this.includeInventoryData != null ? this.includeInventoryData.getElement().isChecked() : false;
        boolean iStock = this.includeStockData != null ? this.includeStockData.getElement().isChecked() : false;
        Timestamp ts = this.dateTimeChooser.getElement().getTimestamp();
        return (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createArticleForecast(new ListWrapper(references), new TimestampWrapper(ts), iInventory, iStock).getValue();
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }
}

