/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.prices;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.TenderTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class ArticlePriceAnalysisComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<ComboBox> includedTypes;
    private TitledItem<CheckBox> includeAllVariants;

    public ArticlePriceAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.includedTypes = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
        this.includedTypes.getElement().addItem(Words.ALL);
        this.includedTypes.getElement().addItem(Words.TENDER);
        this.includedTypes.getElement().addItem(Words.PRODUCTIVE);
        this.includeAllVariants = new TitledItem<CheckBox>(new CheckBox(), "Include all variants", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.includedTypes, "types"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllVariants, "variants"));
    }

    @Override
    public String getTitleString() {
        return Words.PRICE_LIST;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        ArrayList references = new ArrayList();
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        TenderTypeE tender = null;
        tender = this.includedTypes.getElement().getSelectedItem().equals(Words.PRODUCTIVE) ? TenderTypeE.Productive : (this.includedTypes.getElement().getSelectedItem().equals(Words.TENDER) ? TenderTypeE.Tender : TenderTypeE.Both);
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        PegasusFileComplete file = (PegasusFileComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createArticlePriceReport(new ListWrapper(references), new DateWrapper(date), tender, Boolean.valueOf(this.includeAllVariants.getElement().isChecked())).getValue();
        return file;
    }
}

