/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.equipmenttemplate;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisEquipmentTemplateProductsComponent
extends DefaultServerSideAnalysisComponent<EquipmentTemplateComplete, EquipmentTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public AnalysisEquipmentTemplateProductsComponent(AnalysisSmartExternalOpenTool<EquipmentTemplateComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.EQUIPMENT_TEMPLATE;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCTS;
    }

    @Override
    public EquipmentTemplateComplete createReference(EquipmentTemplateComplete item) {
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        Timestamp ts = new Timestamp(date.getTime());
        List references = this.loadItemReferences();
        PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).createEquipmentExport(new ListWrapper(references), new DateWrapper(ts.getTime())).getValue();
        return file;
    }
}

