/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.modules.importer.FlightForecastImporter;
import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.importer.DataImportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UpdateFlightForecastFileBasedComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ClientFileTransferListener {
    private static final long serialVersionUID = 1L;
    private File fileName;
    private TitledItem<ComboBox> forecastType;
    private TextLabel period;
    private TextLabel infoLabel;
    private RDProvider provider;

    public UpdateFlightForecastFileBasedComponent(RDProvider provider) {
        super(true, false, false, false, null);
        this.provider = provider;
        this.getViewContainer().setLayout(new Layout());
        this.period = new TextLabel(Words.SELECT_FORE_CAST_TYPE_AND_PRESS_PREVIEW);
        this.forecastType = new TitledItem<ComboBox>(new ComboBox(), Words.FORECAST_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.forecastType.getElement().addItemListener(this);
        this.infoLabel = new TextLabel();
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(FlightAccess.MODULE_FLIGHT, user);
        boolean maxPaxAllowed = false;
        boolean paxAllowed = false;
        boolean preOrdersAllowed = false;
        for (SubModuleAccessRightComplete sm : r.getSubModules()) {
            if (sm.getModule().getInvokingName().equals(AFlightAccess.ANALYSIS_UPDATE_MAX_PAX.getIdentifier())) {
                maxPaxAllowed = true;
                continue;
            }
            if (sm.getModule().getInvokingName().equals(AFlightAccess.ANALYSIS_UPDATE_PAX_FORECAST_FILE_BASED.getIdentifier())) {
                paxAllowed = true;
                continue;
            }
            if (!sm.getModule().getInvokingName().equals(AFlightAccess.ANALYSIS_UPDATE_PRE_ORDERS.getIdentifier())) continue;
            preOrdersAllowed = true;
        }
        if (maxPaxAllowed) {
            this.forecastType.getElement().addItem(ForecastType.FILE_PAX_MAX_PAX);
        }
        if (paxAllowed) {
            this.forecastType.getElement().addItem(ForecastType.FILE_PAX);
        }
        if (preOrdersAllowed) {
            this.forecastType.getElement().addItem(ForecastType.FILE_PAX_ORDERS);
        }
        this.getViewContainer().add(this.period);
        this.getViewContainer().add(this.forecastType);
        this.getViewContainer().add(this.infoLabel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getStateChange() == 1 && e.getSource() == this.forecastType.getElement()) {
            this.configInfoLabel();
        }
    }

    private void configInfoLabel() {
        ForecastType currentType = (ForecastType)((Object)this.forecastType.getElement().getSelectedItem());
        switch (currentType) {
            case FILE_PAX: 
            case FILE_PAX_MAX_PAX: {
                this.infoLabel.setText("");
                break;
            }
            case FILE_PAX_ORDERS: {
                this.infoLabel.setText(Words.ENSURE_EXCEL_ROWS_ARE_SORTED_BY_DATE_AND_LEG);
                break;
            }
        }
    }

    private void startLoading() {
        ForecastType currentType = (ForecastType)((Object)this.forecastType.getElement().getSelectedItem());
        this.removeInheritedComponents();
        this.ensureAnimation(Words.SELECT_DATA);
        this.popup.disablePreviewButton();
        this.reportTypesLoaded = true;
        switch (currentType) {
            case FILE_PAX: 
            case FILE_PAX_MAX_PAX: 
            case FILE_PAX_ORDERS: {
                MainFrame.isTempRelease = true;
                this.fileName = FileChooserUtil.loadFile();
                MainFrame.isTempRelease = false;
                ThreadSafeLoader.run(this.getJob());
                break;
            }
        }
    }

    @Override
    public void loadReportTypes() {
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.printed) {
            super.enterPressed(isOK);
        } else if (isOK == PopupAction.OK_BACKGROUND || isOK == PopupAction.OK_FOREGROUND || isOK == PopupAction.PREVIEW) {
            this.startLoading();
        } else {
            super.enterPressed(isOK);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    protected String getProgressText() {
        return Words.UPDATE_PAX_FORECAST;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(true);
        }
        if (this.forecastType != null) {
            this.forecastType.setVisible(true);
        }
        if (this.infoLabel != null) {
            this.infoLabel.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(false);
        }
        if (this.forecastType != null) {
            this.forecastType.setVisible(false);
        }
        if (this.infoLabel != null) {
            this.infoLabel.setVisible(false);
        }
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.period != null) {
            this.period.kill();
        }
        this.period = null;
        if (this.forecastType != null) {
            this.forecastType.kill();
        }
        this.forecastType = null;
        if (this.infoLabel != null) {
            this.infoLabel.kill();
        }
        this.infoLabel = null;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UpdateFlightForecastFileBasedComponent.this.ensureAnimation(Words.PROCESS_FILE);
                UpdateFlightForecastFileBasedComponent.this.removeInheritedComponents();
                UpdateFlightForecastFileBasedComponent.this.popup.disablePreviewButton();
                UpdateFlightForecastFileBasedComponent.this.popup.enableOKButton(false);
                UpdateFlightForecastFileBasedComponent.this.popup.enableCancelButton(false);
                if (UpdateFlightForecastFileBasedComponent.this.fileName != null) {
                    File f = UpdateFlightForecastFileBasedComponent.this.fileName;
                    boolean ignoreEnRouteRestriction = UpdateFlightForecastFileBasedComponent.this.provider.isWritable(AFlightAccess.IGNORE_EN_ROUTE_RESTRICTIONS);
                    List<String> warnings = null;
                    ForecastType type = (ForecastType)((Object)((ComboBox)UpdateFlightForecastFileBasedComponent.this.forecastType.getElement()).getSelectedItem());
                    switch (type) {
                        case FILE_PAX: {
                            try {
                                ArrayList<ScreenValidationObject> errors = new ArrayList<ScreenValidationObject>();
                                errors.addAll(new FlightForecastImporter().importFlightForecast(f, UpdateFlightForecastFileBasedComponent.this.animation, ignoreEnRouteRestriction));
                                warnings = new ArrayList();
                                for (ScreenValidationObject o : errors) {
                                    warnings.add(o.getMessage());
                                }
                                break;
                            }
                            catch (ExcelToolkitException e) {
                                if (warnings == null) {
                                    warnings = new ArrayList();
                                }
                                e.printStackTrace();
                                UpdateFlightForecastFileBasedComponent.this.removeAnimation(false, true);
                                UpdateFlightForecastFileBasedComponent.this.showMessage(Words.UNABLE_TO_IMPORT_DATA + ": " + e.getMessage());
                                if (UpdateFlightForecastFileBasedComponent.this.popup == null) break;
                                UpdateFlightForecastFileBasedComponent.this.popup.hideCancelButton();
                                UpdateFlightForecastFileBasedComponent.this.popup.disablePreviewButton();
                                UpdateFlightForecastFileBasedComponent.this.popup.setOkButtonText(Words.CLOSE);
                                UpdateFlightForecastFileBasedComponent.this.printed = true;
                                warnings.add(Words.UNABLE_TO_IMPORT_DATA + ": " + e.getMessage());
                                break;
                            }
                        }
                        case FILE_PAX_MAX_PAX: {
                            FileCommitter c = new FileCommitter(f);
                            c.commit(UpdateFlightForecastFileBasedComponent.this);
                            PegasusFileComplete file = c.getRemoteRef();
                            ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightMaxPax(file, ignoreEnRouteRestriction);
                            warnings = new ArrayList();
                            break;
                        }
                        case FILE_PAX_ORDERS: {
                            FileCommitter c = new FileCommitter(f);
                            c.commit(UpdateFlightForecastFileBasedComponent.this);
                            PegasusFileComplete file = c.getRemoteRef();
                            warnings = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightPreOrders(file, ignoreEnRouteRestriction).getList();
                            break;
                        }
                    }
                    if (warnings != null && !warnings.isEmpty()) {
                        InnerPopupFactory.showWarningDialog(ScreenValidationObject.createList((List)warnings, (ScreenValidationObject.ValidationStateE)ScreenValidationObject.ValidationStateE.FATAL), Words.UNABLE_TO_IMPORT_DATA, (Component)UpdateFlightForecastFileBasedComponent.this);
                    }
                } else {
                    UpdateFlightForecastFileBasedComponent.this.removeAnimation(false, true);
                    UpdateFlightForecastFileBasedComponent.this.showMessage(Words.DATA_IMPORT_CANCELLED + ": no file selected");
                    if (UpdateFlightForecastFileBasedComponent.this.popup != null) {
                        UpdateFlightForecastFileBasedComponent.this.popup.hideCancelButton();
                        UpdateFlightForecastFileBasedComponent.this.popup.disablePreviewButton();
                        UpdateFlightForecastFileBasedComponent.this.popup.setOkButtonText(Words.CLOSE);
                        UpdateFlightForecastFileBasedComponent.this.printed = true;
                    }
                }
                UpdateFlightForecastFileBasedComponent.this.printed = true;
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UpdateFlightForecastFileBasedComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    public void statusChanged(File file, FileTransferState state) {
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        InnerPopupFactory.showErrorDialog(ScreenValidationObject.createMessageString((List)ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "File upload failed")})), (Component)this);
    }

    @Override
    public void fileUploaded(File file, PegasusFileComplete ref) {
    }

    @Override
    public void fileDownloaded(File file) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = UpdateFlightForecastFileBasedComponent.this.layoutInheritedComponents(parent);
            y += UpdateFlightForecastFileBasedComponent.this.border;
            if (UpdateFlightForecastFileBasedComponent.this.period != null) {
                UpdateFlightForecastFileBasedComponent.this.period.setLocation(UpdateFlightForecastFileBasedComponent.this.border, y);
                UpdateFlightForecastFileBasedComponent.this.period.setSize(UpdateFlightForecastFileBasedComponent.this.period.getPreferredSize());
                y = UpdateFlightForecastFileBasedComponent.this.period.getY() + UpdateFlightForecastFileBasedComponent.this.period.getHeight() + UpdateFlightForecastFileBasedComponent.this.border;
            }
            if (UpdateFlightForecastFileBasedComponent.this.forecastType != null) {
                UpdateFlightForecastFileBasedComponent.this.forecastType.setLocation(UpdateFlightForecastFileBasedComponent.this.border, y);
                UpdateFlightForecastFileBasedComponent.this.forecastType.setSize(parent.getWidth() - 2 * UpdateFlightForecastFileBasedComponent.this.border, (int)UpdateFlightForecastFileBasedComponent.this.forecastType.getPreferredSize().getHeight());
                y = UpdateFlightForecastFileBasedComponent.this.forecastType.getY() + UpdateFlightForecastFileBasedComponent.this.forecastType.getHeight() + UpdateFlightForecastFileBasedComponent.this.border;
            }
            if (UpdateFlightForecastFileBasedComponent.this.infoLabel != null) {
                UpdateFlightForecastFileBasedComponent.this.infoLabel.setLocation(UpdateFlightForecastFileBasedComponent.this.border, y);
                UpdateFlightForecastFileBasedComponent.this.infoLabel.setSize(parent.getWidth() - 2 * UpdateFlightForecastFileBasedComponent.this.border, (int)UpdateFlightForecastFileBasedComponent.this.infoLabel.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = UpdateFlightForecastFileBasedComponent.this.getInheritedComponentsHeight();
            if (UpdateFlightForecastFileBasedComponent.this.period != null) {
                h = (int)((double)h + UpdateFlightForecastFileBasedComponent.this.period.getPreferredSize().getHeight());
                h += UpdateFlightForecastFileBasedComponent.this.border;
            }
            if (UpdateFlightForecastFileBasedComponent.this.forecastType != null) {
                h = (int)((double)h + UpdateFlightForecastFileBasedComponent.this.forecastType.getPreferredSize().getHeight());
                h += UpdateFlightForecastFileBasedComponent.this.border;
            }
            if (UpdateFlightForecastFileBasedComponent.this.infoLabel != null) {
                h = (int)((double)h + UpdateFlightForecastFileBasedComponent.this.infoLabel.getPreferredSize().getHeight());
                h += UpdateFlightForecastFileBasedComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }

    private static enum ForecastType {
        FILE_PAX,
        FILE_PAX_MAX_PAX,
        FILE_PAX_ORDERS;


        public String toString() {
            switch (this) {
                case FILE_PAX: {
                    return Words.FORE_CAST_PAX;
                }
                case FILE_PAX_MAX_PAX: {
                    return Words.FORE_CAST_MAX_PAX;
                }
                case FILE_PAX_ORDERS: {
                    return Words.FORE_CAST_ORDERS;
                }
            }
            return "";
        }
    }
}

