/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update.utils;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaxUpdaterTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private List<CabinClassComplete> cabinClasses;
    private Map<CabinClassComplete, Integer> cabinClassIndex = new HashMap<CabinClassComplete, Integer>();
    private boolean historic;
    private double factor;
    private Map<CabinClassComplete, Double> classFactor;

    public PaxUpdaterTable(List<CabinClassComplete> usedCabinClasses, Map<CabinClassComplete, Double> factor) {
        this(usedCabinClasses, false, 0.0);
        this.classFactor = factor;
    }

    public PaxUpdaterTable(List<CabinClassComplete> usedCabinClasses, boolean useHistoric, double factor) {
        super(false, "", false);
        this.historic = useHistoric;
        this.factor = factor;
        this.setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FLIGHT, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth + 5, TableColumnInfo.dateTimeColumnWidth + 5, TableColumnInfo.dateTimeColumnWidth + 5));
        columns.add(new TableColumnInfo(Words.LEG, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 50, 50, 50));
        Collections.sort(usedCabinClasses);
        this.cabinClasses = usedCabinClasses;
        int j = 4;
        double d = 1.0 / (double)usedCabinClasses.size();
        for (CabinClassComplete cc : usedCabinClasses) {
            this.cabinClassIndex.put(cc, j++);
            columns.add(new TableColumnInfo(cc.getCode(), null, null, null, "", 100, 100, 100));
        }
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        for (int i = 4; columns.size() - 1 > i; ++i) {
            ((TableColumnInfo)columns.get(i)).setxExpand(d);
        }
        ((TableColumnInfo)columns.get(columns.size() - 1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel flightNo;
        private TextLabel dateField;
        private TextLabel leg;
        private TextLabel type;
        private List<FromToPanel> paxList;
        private Map<CabinClassComplete, FromToPanel> paxMap;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.paxList = new ArrayList<FromToPanel>();
            this.paxMap = new HashMap<CabinClassComplete, FromToPanel>();
            Node orgFlight = m.getNode().getChildNamed(DtoFieldConstants.orgFlight);
            Node orgLeg = m.getNode().getChildNamed(DtoFieldConstants.orgLeg);
            Node templateFlight = m.getNode().getChildNamed(DtoFieldConstants.templateFlight);
            Node templateLeg = m.getNode().getChildNamed(DtoFieldConstants.templateLeg);
            this.flightNo = new TextLabel(orgFlight.getChildNamed(FlightLight_.outboundCode));
            this.dateField = new TextLabel(orgFlight.getChildNamed(FlightLight_.std), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.leg = new TextLabel(orgLeg, ConverterRegistry.getConverter(LegInfoConverter.class));
            this.type = new TextLabel(Words.INVOICED);
            this.setLayout(new Layout());
            Iterator it = orgLeg.getChildNamed(FlightLegComplete_.paxFigures).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node figure = (Node)it.next();
                if (((PaxFigureComplete)figure.getValue()).getPaxFigureType() != null) continue;
                Node orgNumber = figure.getChildNamed(PaxFigureComplete_.number);
                Node<Integer> maxPax = this.getMaxPaxForClass((Node<FlightLight>)orgFlight, (Node<CabinClassComplete>)figure.getChildNamed(PaxFigureComplete_.cabinClass));
                Node newNumber = this.getPaxForClass((Node<FlightLegComplete>)templateLeg, (Node<CabinClassComplete>)figure.getChildNamed(PaxFigureComplete_.cabinClass));
                if (maxPax == null || newNumber == null) continue;
                if (!PaxUpdaterTable.this.historic) {
                    Double usedFactor1;
                    Node oldParent = maxPax.getParent();
                    newNumber = INodeCreator.getDefaultImpl().getNode4DTO(newNumber.getValue(), false, false);
                    double usedFactor = 1.0;
                    usedFactor = PaxUpdaterTable.this.classFactor != null ? ((usedFactor1 = (Double)PaxUpdaterTable.this.classFactor.get(((PaxFigureComplete)figure.getValue()).getCabinClass())) != null ? usedFactor1 : 1.0) : PaxUpdaterTable.this.factor;
                    newNumber.setValue((Object)((int)((double)((Integer)maxPax.getValue()).intValue() * usedFactor)), 0L);
                    newNumber.setName(DtoFieldConstants.SECOND_NUMBER);
                    oldParent.addChild(newNumber, 0L);
                }
                FromToPanel d = new FromToPanel(maxPax, (Node<Integer>)orgNumber, (Node<Integer>)newNumber, (Node<CabinClassComplete>)figure.getChildNamed(PaxFigureComplete_.cabinClass));
                this.paxList.add(d);
                this.paxMap.put((CabinClassComplete)figure.getChildNamed(PaxFigureComplete_.cabinClass).getValue(), d);
                this.add(d);
            }
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.add(this.flightNo);
            this.add(this.dateField);
            this.add(this.leg);
            this.add(this.type);
            this.add(this.delete);
        }

        private Node<Integer> getPaxForClass(Node<FlightLegComplete> leg, Node<CabinClassComplete> cabinClass) {
            Node paxfigures = leg.getChildNamed(FlightLegComplete_.paxFigures);
            if (paxfigures != null) {
                Iterator it = paxfigures.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node p = (Node)it.next();
                    if (!((CabinClassComplete)p.getChildNamed(PaxFigureComplete_.cabinClass).getValue()).equals(cabinClass.getValue())) continue;
                    return p.getChildNamed(PaxFigureComplete_.number);
                }
            }
            return null;
        }

        private Node<Integer> getMaxPaxForClass(Node<FlightLight> leg, Node<CabinClassComplete> cabinClass) {
            Iterator it = leg.getChildNamed(new DtoField[]{FlightLight_.activeStowingList, StowingListLight_.seatConfigurations}).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node p = (Node)it.next();
                if (!((CabinClassComplete)p.getChildNamed(SeatConfigurationComplete_.cabinClass).getValue()).equals(cabinClass.getValue())) continue;
                p.getChildNamed(SeatConfigurationComplete_.number).setValue((Object)((SeatConfigurationComplete)p.getValue()).getNumber(), 0L);
                return p.getChildNamed(SeatConfigurationComplete_.number);
            }
            return null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        private class FromToPanel
        extends JPanelFadable {
            private static final long serialVersionUID = 1L;
            private TextLabel fromField;
            private TextField toField;
            private Node<CabinClassComplete> cabinClass;

            public FromToPanel(Node<Integer> maxPax, Node<Integer> from, Node<Integer> to, Node<CabinClassComplete> cabinClass) {
                String t = "";
                t = t + Phrase.getPhrase((String)Phrase.MAX_FROM_TO, (Object[])new Object[]{maxPax.getValue(), from.getValue()});
                this.fromField = new TextLabel(t);
                this.toField = new TextField(to, TextFieldType.INT);
                this.cabinClass = cabinClass;
                this.setLayout(new InnerLayout());
                this.add(this.fromField);
                this.add(this.toField);
            }

            private class InnerLayout
            extends DefaultLayout {
                private InnerLayout() {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, (int)FromToPanel.this.fromField.getPreferredSize().getHeight());
                }

                @Override
                public void layoutContainer(Container parent) {
                    int w = parent.getWidth() - 4;
                    FromToPanel.this.fromField.setLocation(0, 0);
                    FromToPanel.this.fromField.setSize(w /= 2, (int)FromToPanel.this.fromField.getPreferredSize().getHeight());
                    FromToPanel.this.toField.setLocation(FromToPanel.this.fromField.getX() + FromToPanel.this.fromField.getWidth() + 2, 0);
                    FromToPanel.this.toField.setSize(w, (int)FromToPanel.this.toField.getPreferredSize().getHeight());
                }
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.flightNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.dateField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.dateField.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.dateField.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.dateField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.leg.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.leg.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.leg.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.leg.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                int currentIndex = 4;
                for (CabinClassComplete cc : PaxUpdaterTable.this.cabinClasses) {
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentIndex);
                    FromToPanel cpf = (FromToPanel)TableRowImpl.this.paxMap.get(cc);
                    if (cpf != null) {
                        cpf.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - cpf.getPreferredSize().getHeight()) / 2.0));
                        cpf.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)cpf.getPreferredSize().getHeight());
                    }
                    ++currentIndex;
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentIndex);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

