/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.articleloading;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.List;

public class AnalysisArticleSummaryComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> department;
    private TitledItem<CheckBox> includeMeals;
    private TitledItem<CheckBox> includeSPML;
    private TitledItem<CheckBox> includeAlaCarte;
    private TitledItem<CheckBox> includeAdditional;
    private TitledItem<CheckBox> includeStandards;
    private TitledItem<CheckBox> includeArticles;

    public AnalysisArticleSummaryComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.includeMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPML = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML, TitledItem.TitledItemOrientation.EAST);
        this.includeAlaCarte = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALACARTE, TitledItem.TitledItemOrientation.EAST);
        this.includeAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeStandards = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals.getElement().setChecked(true);
        this.includeSPML.getElement().setChecked(true);
        this.includeAlaCarte.getElement().setChecked(true);
        this.includeAdditional.getElement().setChecked(true);
        this.includeStandards.getElement().setChecked(true);
        this.includeArticles.getElement().setChecked(true);
        this.addOptionsItem(new ComboBoxAnalysisItem(this.department, "department"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeMeals, "meals"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSPML, "spml"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAlaCarte, "alaCarte"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAdditional, "additionals"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStandards, "standards"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeArticles, "overview"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean innerComponent = super.isInnerComponent(c);
        if (innerComponent) {
            return innerComponent;
        }
        return this.department != null && this.department.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_LOADING;
    }

    @Override
    public boolean chooseExportFormat() {
        return true;
    }

    @Override
    public String getFileEnding() {
        if (this.pdfRadioButton != null && ((RadioButton)this.pdfRadioButton.getElement()).isChecked()) {
            return ".pdf";
        }
        return ".xlsx";
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        return new FlightReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        CostCenterComplete dep = (CostCenterComplete)this.department.getElement().getNode().getValue();
        boolean showMeals = this.includeMeals.getElement().isChecked();
        boolean showSPML = this.includeSPML.getElement().isChecked();
        boolean showAlaCarte = this.includeAlaCarte.getElement().isChecked();
        boolean showAdditional = this.includeAdditional.getElement().isChecked();
        boolean showStandards = this.includeStandards.getElement().isChecked();
        boolean showArticles = this.includeArticles.getElement().isChecked();
        boolean asExcel = !((RadioButton)this.pdfRadioButton.getElement()).isChecked();
        FlightDataReportConfig config = new FlightDataReportConfig();
        config.setDepartment(dep);
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getArticleSummarySheet(new ListWrapper(references), config, showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles, asExcel).getValue();
        return file;
    }
}

