/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.articleloadingsheet;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;

public class AnalysisFlightArticleLoadingSheetComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeMeals;
    private TitledItem<CheckBox> includeSPML;
    private TitledItem<CheckBox> includeAlaCarte;
    private TitledItem<CheckBox> includeAdditional;
    private TitledItem<CheckBox> includeStandards;
    private TitledItem<CheckBox> includeArticles;

    public AnalysisFlightArticleLoadingSheetComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.includeMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPML = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML, TitledItem.TitledItemOrientation.EAST);
        this.includeAlaCarte = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALACARTE, TitledItem.TitledItemOrientation.EAST);
        this.includeAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeStandards = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals.getElement().setChecked(true);
        this.includeSPML.getElement().setChecked(true);
        this.includeAlaCarte.getElement().setChecked(true);
        this.includeAdditional.getElement().setChecked(true);
        this.includeStandards.getElement().setChecked(true);
        this.includeArticles.getElement().setChecked(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeMeals, "meals"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSPML, "spml"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAlaCarte, "alaCarte"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAdditional, "additional"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStandards, "standard"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeArticles, "overview"));
    }

    @Override
    public String getTitleString() {
        return Words.PRINT_ARTICLE_LOADING_SHEET;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List flights = this.loadItemReferences();
        boolean showMeals = this.includeMeals.getElement().isChecked();
        boolean showSPML = this.includeSPML.getElement().isChecked();
        boolean showAlaCarte = this.includeAlaCarte.getElement().isChecked();
        boolean showAdditional = this.includeAdditional.getElement().isChecked();
        boolean showStandards = this.includeStandards.getElement().isChecked();
        boolean showArticles = this.includeArticles.getElement().isChecked();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getArticleLoadingSheet(new ListWrapper(flights), showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles).getValue();
        return file;
    }
}

