/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.pax.detailed;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.NotPersistedAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.RadioButtonAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.report.FlightProductionResourceTypeE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrintFlightPaxComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> selected;
    private TitledItem<RadioButton> allClasses;
    private TitledItem<RadioButton> onlyMainClasses;
    private TitledItem<RadioButton> groupNotMainClasses;
    private TitledItem<RadioButton> groupAll;
    private TitledItem<CheckBox> splitSPML;
    private TitledItem<CheckBox> splitAlaCarte;
    private TitledItem<CheckBox> splitAdditionalOrders;
    private List<CheckBox> allBoxes;
    private TitledItem<ComboBox> sortDirection;

    public PrintFlightPaxComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.allBoxes = new ArrayList<CheckBox>();
        try {
            Node types = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxFigureTypeComplete.class);
            Collections.sort((List)types.getValue());
            for (PaxFigureTypeComplete t : (List)types.getValue()) {
                if (t.getIsDeleted().booleanValue()) continue;
                TitledItem<CheckBox> box = new TitledItem<CheckBox>(new CheckBox(), t.getName(), TitledItem.TitledItemOrientation.EAST);
                box.getElement().setUserObject(t);
                this.addOptionsItem(new CheckBoxAnalysisItem(box, t.getName()));
                this.allBoxes.add(box.getElement());
            }
            TitledItem<CheckBox> box = new TitledItem<CheckBox>(new CheckBox(), Words.INVOICED_PAX, TitledItem.TitledItemOrientation.EAST);
            box.getElement().setUserObject(null);
            this.allBoxes.add(box.getElement());
            this.addOptionsItem(new CheckBoxAnalysisItem(box, "invoiced"));
            this.selected = new TitledItem<CheckBox>(new CheckBox(), Words.SELECTED, TitledItem.TitledItemOrientation.EAST);
            this.selected.getElement().setUserObject(null);
            this.selected.getElement().setChecked(true);
            this.allBoxes.add(this.selected.getElement());
            this.addOptionsItem(new CheckBoxAnalysisItem(this.selected, "selected"));
        }
        catch (ClientServerCallException e) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
        }
        this.addOptionsItem(new NotPersistedAnalysisItem(new HorizontalSeparator()));
        this.allClasses = new TitledItem<RadioButton>(new RadioButton(), Words.ALL, TitledItem.TitledItemOrientation.EAST);
        this.onlyMainClasses = new TitledItem<RadioButton>(new RadioButton(), Words.ONLY_MAIN_CLASSES, TitledItem.TitledItemOrientation.EAST);
        this.groupNotMainClasses = new TitledItem<RadioButton>(new RadioButton(), Words.GROUP_NOT_MAIN_CLASSES, TitledItem.TitledItemOrientation.EAST);
        this.groupNotMainClasses.getElement().setChecked(true);
        this.groupAll = new TitledItem<RadioButton>(new RadioButton(), Words.GROUP_ALL, TitledItem.TitledItemOrientation.EAST);
        this.sortDirection = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortDirection.getElement().addItem(Words.BY_DATE);
        this.sortDirection.getElement().addItem(Words.BY_OUTBOUND_CODE);
        this.sortDirection.getElement().setSelectedItem(Words.BY_OUTBOUND_CODE);
        this.addOptionsItem(new RadioButtonAnalysisItem(this.allClasses, "allClasses"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.onlyMainClasses, "onlyMain"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.groupNotMainClasses, "groupNotMain"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.groupAll, "groupAll"));
        this.addOptionsItem(new NotPersistedAnalysisItem(new HorizontalSeparator()));
        this.splitSPML = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_SPML, TitledItem.TitledItemOrientation.EAST);
        this.splitAlaCarte = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_ALACARTE, TitledItem.TitledItemOrientation.EAST);
        this.splitAdditionalOrders = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitSPML, "splitSPML"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitAlaCarte, "splitAlaCarte"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitAdditionalOrders, "splitAdditionalOrders"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.sortDirection, "sort"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getTitleString() {
        return Words.PAX_DETAILS;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List references = this.loadItemReferences();
        FlightProductionResourceTypeE type = null;
        if (this.allClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.ALL;
        } else if (this.onlyMainClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.ONLY_MAIN_CLASSES;
        } else if (this.groupNotMainClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.GROUP_NOT_MAIN;
        } else if (this.groupAll.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.GROUP_ALL;
        }
        ArrayList<PaxFigureTypeComplete> usedTypes = new ArrayList<PaxFigureTypeComplete>();
        for (CheckBox b : this.allBoxes) {
            if (b == this.selected.getElement() || !b.isChecked()) continue;
            usedTypes.add((PaxFigureTypeComplete)b.getUserObject());
        }
        boolean selectedOnly = this.selected.getElement().isChecked();
        ASearchConfiguration fc = this.getSearchConfiguration();
        boolean sortByDate = this.sortDirection.getElement().getSelectedItem().equals(Words.BY_DATE);
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createPaxExport(new ListWrapper(references), selectedOnly, new ListWrapper(usedTypes), type, fc, this.splitSPML.getElement().isChecked(), this.splitAlaCarte.getElement().isChecked(), this.splitAdditionalOrders.getElement().isChecked(), sortByDate).getValue();
        return file;
    }
}

