/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.print.PrinterToolkitConfiguration;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.List;
import javax.print.PrintService;

public abstract class AnalysisPrintAllSheetsComponent
extends AsyncSimpleExportPopupInsert<FlightLight> {
    private static final long serialVersionUID = 1L;
    protected TitledItem<ComboBox> printer;
    protected TitledItem<TextField> copies;
    protected TitledItem<CheckBox> mergeAllIntoSinglePDF;

    public AnalysisPrintAllSheetsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, false, reportType);
    }

    public AnalysisPrintAllSheetsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, boolean chooseExportFormat, ReportTypeE reportType) {
        super(defaultAnalysis, chooseExportFormat, reportType);
    }

    protected boolean useMerge() {
        return true;
    }

    public abstract List<PegasusFileComplete> processSingleFile(FlightLight var1, AGenericReportConfiguration var2) throws ClientServerCallException;

    @Override
    public void doProcessData() {
        if (this.mergeAllIntoSinglePDF != null && this.mergeAllIntoSinglePDF.getElement().isChecked()) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    AnalysisPrintAllSheetsComponent.this.writeConfigurationValues();
                    ASearchConfiguration searchConfiguration = AnalysisPrintAllSheetsComponent.this.getSearchConfiguration();
                    if (!(searchConfiguration instanceof ADtoSearchConfiguration)) {
                        InnerPopupFactory.showErrorDialog(new Exception("Generic Reports are not Supported for EntitySearchConfigurations"), (Component)AnalysisPrintAllSheetsComponent.this);
                    }
                    AGenericReportConfiguration reportConfiguration = AnalysisPrintAllSheetsComponent.this.getReportConfiguration();
                    SearchResultIterator sri = new SearchResultIterator(searchConfiguration);
                    int currentCount = 1;
                    long maxCount = sri.getSize();
                    while (sri.hasNext()) {
                        FlightLight f = (FlightLight)sri.next();
                        AnalysisPrintAllSheetsComponent.this.ensureAnimation("Processing Data Set " + currentCount + " of " + maxCount);
                        List<PegasusFileComplete> result = AnalysisPrintAllSheetsComponent.this.processSingleFile(f, reportConfiguration);
                        ++currentCount;
                        if (result == null) {
                            AnalysisPrintAllSheetsComponent.this.nullReturned();
                            continue;
                        }
                        for (PegasusFileComplete fileComplete : result) {
                            AnalysisPrintAllSheetsComponent.this.processPegasusFile(fileComplete);
                        }
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return AnalysisPrintAllSheetsComponent.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            super.doProcessData();
        }
    }

    @Override
    public File getSelectedFile() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.printer != null) {
            this.printer.setEnabled(isEnabled);
        }
        if (this.copies != null) {
            this.copies.setEnabled(isEnabled);
        }
        if (this.mergeAllIntoSinglePDF != null) {
            this.mergeAllIntoSinglePDF.setEnabled(isEnabled);
        }
    }

    @Override
    protected void processOkPressed(PopupAction isOK) {
        this.currentState = 3;
        super.enterPressed(isOK);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.setOkButtonText(Words.PRINT);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.printer.setVisible(false);
        this.copies.setVisible(false);
        if (this.mergeAllIntoSinglePDF != null) {
            this.mergeAllIntoSinglePDF.setVisible(false);
        }
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.printer.setVisible(true);
        this.copies.setVisible(true);
        if (this.mergeAllIntoSinglePDF != null) {
            this.mergeAllIntoSinglePDF.setVisible(true);
        }
    }

    @Override
    public int layoutCustomItems(Container parent, int h, int width) {
        int h2 = this.layoutPrinter(this.border, h, width - this.border);
        return super.layoutCustomItems(parent, h2 += this.border, width);
    }

    @Override
    public int getCustomItemHeight() {
        int h = super.getCustomItemHeight();
        h += this.border;
        h = (int)((double)h + this.printer.getPreferredSize().getHeight());
        if (this.mergeAllIntoSinglePDF != null) {
            h += this.border / 2;
            h = (int)((double)h + this.mergeAllIntoSinglePDF.getPreferredSize().getHeight());
        }
        return h += this.border;
    }

    @Override
    protected void processPegasusFile(PegasusFileComplete res) throws Exception {
        if (!this.popup.isPreview()) {
            this.processFile(res);
        } else {
            super.processPegasusFile(res);
            this.writeDefaultPrinter();
        }
    }

    @Override
    public final boolean tryToGrabFocus() {
        if (this.printer != null && this.printer.isEnabled()) {
            this.printer.getElement().requestFocusInWindow();
            return true;
        }
        return false;
    }

    private void fillPrinters() {
        List l = PrinterToolkit.getAvailablePrinters();
        for (PrintService t : l) {
            this.printer.getElement().addItem(PrinterToolkit.convertPrintServiceToString((PrintService)t));
        }
        PrintService s = PrintPopupToolkit.getDefaultPrinter((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        if (s != null) {
            this.printer.getElement().setSelectedItem(PrinterToolkit.convertPrintServiceToString((PrintService)s));
        }
    }

    protected PrintService getSelectedPrinter() {
        if (this.printer != null && this.printer.getElement() != null && this.printer.getElement().getSelectedItem() != null) {
            String pn = (String)this.printer.getElement().getSelectedItem();
            PrintService t = PrinterToolkit.converterStringToPrintService((String)pn);
            return t;
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    protected String getNumberOfSavedCopies() {
        return PrintPopupToolkit.getDefaultCopyCount((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    protected String getSinglePDFSaved() {
        return PrintPopupToolkit.getDefaultSinglePDF((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    @Override
    public void addOptionItems() {
        this.printer = new TitledItem<ComboBox>(new ComboBox(), Words.PRINTER, TitledItem.TitledItemOrientation.NORTH);
        this.copies = new TitledItem<TextField>(new TextField(), Words.COPIES, TitledItem.TitledItemOrientation.NORTH);
        this.copies.getElement().setText(this.getNumberOfSavedCopies());
        this.getViewContainer().add(this.printer);
        this.getViewContainer().add(this.copies);
        if (this.useMerge()) {
            this.mergeAllIntoSinglePDF = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_EACH_FLIGHT_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
            this.mergeAllIntoSinglePDF.getElement().loadState(this.getSinglePDFSaved(), "");
            this.getViewContainer().add(this.mergeAllIntoSinglePDF);
        }
        this.fillPrinters();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        if (this.printer != null && this.printer.getElement().getItemCount() > 0) {
            focusList.addAll(this.printer.getFocusComponents());
        }
        if (this.copies != null && this.copies.isEnabled()) {
            focusList.addAll(this.copies.getFocusComponents());
        }
        if (this.mergeAllIntoSinglePDF != null && this.mergeAllIntoSinglePDF.isEnabled()) {
            focusList.addAll(this.mergeAllIntoSinglePDF.getFocusComponents());
        }
        return focusList;
    }

    protected int layoutPrinter(int x, int y, int w) {
        if (this.printer.isVisible()) {
            this.printer.setLocation(x, y);
            this.printer.setSize(w - (2 * x + 80), (int)this.printer.getPreferredSize().getHeight());
            this.copies.setLocation(this.printer.getX() + this.printer.getWidth() + this.border, y);
            this.copies.setSize(80, (int)this.copies.getPreferredSize().getHeight());
            if (this.mergeAllIntoSinglePDF != null) {
                this.mergeAllIntoSinglePDF.setLocation(x, this.printer.getY() + this.printer.getHeight() + this.border / 2);
                this.mergeAllIntoSinglePDF.setSize(this.mergeAllIntoSinglePDF.getPreferredSize());
            }
            int h = this.copies.getY() + this.copies.getHeight();
            if (this.mergeAllIntoSinglePDF != null) {
                h = (int)((double)h + ((double)(this.border / 2) + this.mergeAllIntoSinglePDF.getPreferredSize().getHeight()));
            }
            return h;
        }
        return y;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printer != null) {
            this.printer.kill();
        }
        if (this.copies != null) {
            this.copies.kill();
        }
        if (this.mergeAllIntoSinglePDF != null) {
            this.mergeAllIntoSinglePDF.kill();
        }
        this.printer = null;
        this.copies = null;
        this.mergeAllIntoSinglePDF = null;
    }

    protected boolean processFile(PegasusFileComplete reference) throws ClientException {
        return this.processFile(reference, this.getCopies());
    }

    protected boolean processFile(PegasusFileComplete reference, int cps) throws ClientException {
        this.writeConfigurationValues();
        try {
            MainFrame.isTempRelease = true;
            this.writeDefaultPrinter();
            if (!PrintPopupToolkit.printFile(reference, "", this.getSelectedPrinter(), null, false, cps)) {
                InnerPopupFactory.showErrorDialog("Unable to print Sheet", (Component)this);
            }
            boolean bl = true;
            return bl;
        }
        catch (ClientException e) {
            throw e;
        }
        finally {
            MainFrame.isTempRelease = false;
        }
    }

    private void writeDefaultPrinter() {
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        PrinterToolkitConfiguration c = PrinterToolkitConfiguration.loadConfiguration((UserLight)currentUser);
        if (c == null) {
            c = new PrinterToolkitConfiguration();
        }
        if (this.printer != null && this.printer.getElement().getSelectedItem() != null) {
            c.updateProperty("printer", (String)this.printer.getElement().getSelectedItem());
        }
        if (this.copies.getElement() != null && this.copies.getElement().getText() != null) {
            c.updateProperty("copies", this.copies.getElement().getText());
        }
        if (this.mergeAllIntoSinglePDF != null && this.mergeAllIntoSinglePDF.getElement() != null) {
            c.updateProperty("singleFile", this.mergeAllIntoSinglePDF.getElement().getPersistString());
        }
        PrinterToolkitConfiguration.saveConfiguration((UserLight)currentUser, (PrinterToolkitConfiguration)c);
    }

    private int getCopies() {
        int i = 1;
        if (this.copies != null) {
            String t = this.copies.getElement().getText();
            try {
                i = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                i = 1;
            }
        }
        return i;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }
}

