/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printallais;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisAllergenInfoSheetsConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.Collections;
import java.util.List;

public class AnalysisPrintAllFlightAISComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;
    protected TitledItem<CheckBox> includeAllergenCodeIndex;
    protected TitledItem<CheckBox> includeSPML;
    protected TitledItem<CheckBox> includeAlaCarte;
    protected TitledItem<CheckBox> includeAdditionals;
    protected TitledItem<CheckBox> includeStandard;
    protected TitledItem<ComboBox> sortBy;

    public AnalysisPrintAllFlightAISComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, true, reportType);
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        FlightAnalysisAllergenInfoSheetsConfiguration config = (FlightAnalysisAllergenInfoSheetsConfiguration)flightConfig;
        ReportFileComplete reportFileComplete = this.getSelectedReport();
        PegasusFileComplete fileComplete = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateAllergenInfoSheetReport(new FlightReference(flight.getId()), ReportingOutputFormatE.PDF, reportFileComplete, config.getIncludeSPML().booleanValue(), config.getIncludeAlaCarte().booleanValue(), config.getIncludeAdditionals().booleanValue(), config.getIncludeStandard().booleanValue(), config.getSortByMealPlan().booleanValue(), config.getIncludeAllergenCodeIndex().booleanValue()).getValue();
        return Collections.singletonList(fileComplete);
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void addOptionItems() {
        super.addOptionItems();
        this.includeAllergenCodeIndex = new TitledItem<CheckBox>(new CheckBox(), "Include Allergen Code Index", TitledItem.TitledItemOrientation.EAST);
        this.includeAdditionals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPML = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML, TitledItem.TitledItemOrientation.EAST);
        this.includeAlaCarte = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALACARTE, TitledItem.TitledItemOrientation.EAST);
        this.includeStandard = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.includeAdditionals.getElement().setChecked(true);
        this.includeSPML.getElement().setChecked(true);
        this.includeAlaCarte.getElement().setChecked(true);
        this.includeStandard.getElement().setChecked(true);
        this.sortBy.getElement().addItem(Words.MEALPLAN);
        this.sortBy.getElement().addItem(Words.NUMBER);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllergenCodeIndex, "includeAllergenCodeIndex"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAdditionals, "includeAdditional"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSPML, "includeSPML"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAlaCarte, "includeAlaCarte"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStandard, "includeStandard"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.sortBy, "sortBy"));
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getTitleString() {
        return Words.AIS_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisAllergenInfoSheets;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisAllergenInfoSheetsConfiguration config = new FlightAnalysisAllergenInfoSheetsConfiguration();
        config.setReportType(this.getReportType());
        config.setIncludeSPML(Boolean.valueOf(this.includeSPML.getElement().isChecked()));
        config.setIncludeAlaCarte(Boolean.valueOf(this.includeAlaCarte.getElement().isChecked()));
        config.setIncludeAdditionals(Boolean.valueOf(this.includeAdditionals.getElement().isChecked()));
        config.setIncludeStandard(Boolean.valueOf(this.includeStandard.getElement().isChecked()));
        config.setIncludeAllergenCodeIndex(Boolean.valueOf(this.includeAllergenCodeIndex.getElement().isChecked()));
        boolean sortByMealPlan = false;
        if (this.sortBy != null && this.sortBy.getElement().getSelectedItem().equals(Words.MEALPLAN)) {
            sortByMealPlan = true;
        }
        boolean sortByNumber = false;
        if (this.sortBy != null && this.sortBy.getElement().getSelectedItem().equals(Words.NUMBER)) {
            sortByNumber = true;
        }
        config.setSortByMealPlan(Boolean.valueOf(sortByMealPlan));
        config.setSortByNumber(Boolean.valueOf(sortByNumber));
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        if (this.excelRadioButton != null && ((RadioButton)this.excelRadioButton.getElement()).isChecked()) {
            format = ReportingOutputFormatE.XLSX;
        }
        config.setReportFormatType(format);
        return config;
    }
}

