/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printalllabels;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisLabelsConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class AnalysisPrintFlightLabelsComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser periodChooser;
    protected TitledItem<CheckBox> includeRegularLabels;
    protected TitledItem<CheckBox> includeSPMLLabels;
    protected TitledItem<CheckBox> differentOnly;
    protected TitledItem<CheckBox> withContentOnly;
    protected TitledItem<ComboBox> department;
    protected TitledItem<ComboBox> colors;

    public AnalysisPrintFlightLabelsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, reportType);
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        FlightAnalysisLabelsConfiguration aconfig = (FlightAnalysisLabelsConfiguration)flightConfig;
        ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
        StowingListReportConfiguration config = aconfig.getConfig();
        config.setLegs(flight.getLegs());
        config.setDto((IDTO)new FlightReference(flight.getId()));
        aconfig.setTimePeriod(this.periodChooser.getTimePeriod());
        ServiceReturnWithMessage serviceReturn = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).printFlightLabel(config, config.getSpmlLabel().booleanValue(), config.getDifferentOnly().booleanValue(), config.getLegs(), config.getLabelWithContents().booleanValue());
        List o = (List)serviceReturn.getObject();
        for (String s : serviceReturn.getMessage()) {
            warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, s));
        }
        if (warnings.size() > 0) {
            InnerPopupFactory.showMessageDialog(warnings, "Label Validation", (Component)this);
        }
        return o;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void addOptionItems() {
        super.addOptionItems();
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        TimestampPeriodComplete tp = new TimestampPeriodComplete(new Timestamp(p.getStartDate().getTime()), new Timestamp(p.getEndDate().getTime()));
        this.periodChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)tp, false, false));
        this.includeRegularLabels = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_REGULAR_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPMLLabels = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.differentOnly = new TitledItem<CheckBox>(new CheckBox(), Words.DIFFERENT_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.withContentOnly = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_EMPTY_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.colors = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.LABEL_COLOR), TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new TimePeriodEditorAnalysisItem(this.periodChooser, "time"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeRegularLabels, "includeRegularLabels"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSPMLLabels, "includeSPMLLabels"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.differentOnly, "differentOnly"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.withContentOnly, "withContentOnly"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.department, "department"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.colors, "colors"));
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    public void nullReturned() {
        InnerPopupFactory.showErrorDialog("No Label Information found", (Component)this);
    }

    @Override
    public ASearchConfiguration<FlightLight, ?> getSearchConfiguration() {
        ASearchConfiguration config = super.getSearchConfiguration();
        FlightSearchConfiguration flightConfig = (FlightSearchConfiguration)config;
        TimestampPeriodComplete timePeriod = this.periodChooser.getTimePeriod();
        flightConfig.setDayTimePeriod(timePeriod);
        flightConfig.setDayPeriod(new PeriodComplete(new Date(timePeriod.getStartTime().getTime()), new Date(timePeriod.getEndTime().getTime())));
        return config;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisLabelsConfiguration config = new FlightAnalysisLabelsConfiguration();
        config.setReportType(this.getReportType());
        config.setRegularLabel(Boolean.valueOf(this.includeRegularLabels.getElement().isChecked()));
        config.setSpmlLabel(Boolean.valueOf(this.includeSPMLLabels.getElement().isChecked()));
        config.setDifferentOnly(Boolean.valueOf(this.differentOnly.getElement().isChecked()));
        config.setHideEmpty(Boolean.valueOf(this.withContentOnly.getElement().isChecked()));
        config.setTimePeriod(this.periodChooser.getTimePeriod());
        if (this.colors.getElement().getSelectedItem() instanceof Node) {
            Node c = (Node)this.colors.getElement().getSelectedItem();
            config.setLabelColor((ColorComplete)c.getValue());
        } else {
            config.setLabelColor(null);
        }
        if (this.department.getElement().getSelectedItem() instanceof Node) {
            Node d = (Node)this.department.getElement().getSelectedItem();
            config.setDepartment((CostCenterComplete)d.getValue());
        } else {
            config.setDepartment(null);
        }
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        config.setReportFormatType(format);
        return config;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisLabels;
    }
}

