/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.transactions;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxROAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;

public class AnalysisFlightTransactionComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBoxRO> includeIrregularity;
    private TitledItem<CheckBox> includeHistoryIrregularity;

    public AnalysisFlightTransactionComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.includeIrregularity = new TitledItem<CheckBoxRO>(new CheckBoxRO(), Words.INCLUDE_IRREGULARITY + " (always included)", TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity.getElement().setChecked(true);
        this.includeHistoryIrregularity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HISTORY_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeHistoryIrregularity.getElement().setChecked(true);
        this.getViewContainer().add(this.includeHistoryIrregularity);
        this.addOptionsItem(new CheckBoxROAnalysisItem(this.includeIrregularity, "includeIrregularity"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHistoryIrregularity, "includeHistoryIrregularity"));
    }

    @Override
    public String getTitleString() {
        return Words.TRANSACTIONS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        boolean historyIrregularity = this.includeHistoryIrregularity != null ? this.includeHistoryIrregularity.getElement().isChecked() : false;
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getFlightsTransactionReport(new ListWrapper(s), historyIrregularity).getValue();
        return file;
    }
}

