/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flightschedule.specs;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.report.FlightScheduleReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class AnalysisFlightScheduleSpecificationComponent
extends DefaultServerSideAnalysisComponent<FlightScheduleLight, FlightScheduleReference> {
    private static final long serialVersionUID = 1L;
    private DateChooser dueDate;
    private boolean isNoPro;

    public AnalysisFlightScheduleSpecificationComponent(AnalysisSmartExternalOpenTool<FlightScheduleLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!this.isNoPro) {
            this.dueDate = new DateChooser();
            this.addOptionsItem(new DateChooserAnalysisItem(new TitledItem<DateChooser>(this.dueDate, "Due Date", TitledItem.TitledItemOrientation.EAST), "dueDate"));
        }
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE_SUMMARY;
    }

    @Override
    public String getTitleValue() {
        return Words.INVOICE;
    }

    @Override
    public FlightScheduleReference createReference(FlightScheduleLight item) {
        return new FlightScheduleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List schedules = this.loadItemReferences();
        Date selectedDate = this.dueDate.getSelectedDate();
        FlightScheduleReportConfiguration conf = new FlightScheduleReportConfiguration();
        conf.setDueDate(new Timestamp(selectedDate.getTime()));
        conf.setReportFormatType(ReportingOutputFormatE.XLSX);
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).exportFlightScheduleSpecifications(new ListWrapper(schedules), conf).getValue();
        return file;
    }
}

