/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.inventory.remote.history;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.InventorySearchTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AnalysisInventoryHistoryComponent
extends DefaultScrollablePrintPopup2<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private Node<InventoryDetailsReportConfiguration> configNode;
    private InventorySearchTable startInventories;

    public AnalysisInventoryHistoryComponent() {
        super(false, false, null);
        InventoryDetailsReportConfiguration config = new InventoryDetailsReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.installTables();
        this.setEnabled(true);
    }

    private void installTables() {
        this.startInventories = new InventorySearchTable();
        this.startInventories.getModel().setNode((Node)new ViewNode(Words.START_INVENTORY));
        this.getViewContainer().add(this.startInventories);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> validationObjects = super.validateBeforePrint();
        if (validationObjects == null) {
            validationObjects = new ArrayList<ScreenValidationObject>();
        }
        if (this.startInventories.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_START_INVENTORY));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.startInventories.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.startInventories);
        return focusList;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY_TRANSITION;
    }

    @Override
    public String getTitleValue() {
        return Words.INVENTORY;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.startInventories != null) {
            this.startInventories.kill();
        }
        this.startInventories = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.startInventories != null) {
            this.startInventories.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.startInventories != null) {
            this.startInventories.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = AnalysisInventoryHistoryComponent.this.getSelectedReport();
                AnalysisInventoryHistoryComponent.this.configNode.commit();
                InventoryDetailsReportConfiguration config = (InventoryDetailsReportConfiguration)AnalysisInventoryHistoryComponent.this.configNode.getValue();
                config.setStylesheet(file);
                for (Table2RowPanel row : AnalysisInventoryHistoryComponent.this.startInventories.getRows()) {
                    Node n = row.getModel().getNode();
                    if (n.getValue() == null) continue;
                    InventoryReference inv = new InventoryReference(((InventoryReference)n.getValue()).getId());
                    config.getStartInventories().add(inv);
                }
                PegasusFileComplete t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryHistory(config).getValue();
                AnalysisInventoryHistoryComponent.this.processFile(t);
                ViewNode ret = new ViewNode("batchReturn");
                ret.setValue((Object)true, 0L);
                return ret;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AnalysisInventoryHistoryComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = AnalysisInventoryHistoryComponent.this.layoutInheritedComponents(parent);
            if (AnalysisInventoryHistoryComponent.this.startInventories != null) {
                AnalysisInventoryHistoryComponent.this.startInventories.setLocation(AnalysisInventoryHistoryComponent.this.border, y + AnalysisInventoryHistoryComponent.this.border);
                AnalysisInventoryHistoryComponent.this.startInventories.setSize(parent.getWidth() - 2 * AnalysisInventoryHistoryComponent.this.border, 240);
                y = AnalysisInventoryHistoryComponent.this.startInventories.getY() + AnalysisInventoryHistoryComponent.this.startInventories.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AnalysisInventoryHistoryComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += AnalysisInventoryHistoryComponent.this.border;
            if (AnalysisInventoryHistoryComponent.this.animation != null) {
                return new Dimension(w, h);
            }
            if (AnalysisInventoryHistoryComponent.this.startInventories != null) {
                h += 240;
                h += AnalysisInventoryHistoryComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

