/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.masterdata;

import ch.icit.pegasus.client.gui.hud.submoduleprovider.MasterDataSubModuleProvider;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.ExcelExportPopupInsert;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;

public class MasterDataAnalysisComponent<T extends IDTO>
extends ExcelExportPopupInsert {
    private static final long serialVersionUID = 1L;
    private MasterDataSubModuleProvider<T> subModuleProvider;
    private int itemsExported = 0;
    private List<JPanel> customItems = new ArrayList<JPanel>();

    public MasterDataAnalysisComponent(MasterDataSubModuleProvider<T> subProv) {
        super(true);
        this.subModuleProvider = subProv;
        TextLabel text = new TextLabel(Phrase.getPhrase((String)Phrase.EXPORT, (Object[])new Object[]{subProv.getInsertName()}));
        this.addOptionsItem(text);
    }

    public void addOptionsItem(JPanel ti) {
        this.customItems.add(ti);
        this.getViewContainer().add(ti);
        this.revalidate();
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Class<AMasterDataComplete> exportClass = MasterDataAnalysisComponent.this.getExportClass();
                if (exportClass == null) {
                    throw new IllegalStateException("Export not yet supported");
                }
                PegasusFileComplete file = (PegasusFileComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).createReport(exportClass, MasterDataAnalysisComponent.this.getSubModuleProvider().getInsertName()).getValue();
                File f = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
                FileUtils.moveFile((File)f, (File)MasterDataAnalysisComponent.this.getSelectedFile());
                if (MasterDataAnalysisComponent.this.popup.isPreview()) {
                    Desktop.getDesktop().open(f);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MasterDataAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        for (JPanel custom : this.customItems) {
            if (custom == null) continue;
            custom.setVisible(false);
        }
    }

    public MasterDataSubModuleProvider<T> getSubModuleProvider() {
        return this.subModuleProvider;
    }

    public void setSubModuleProvider(MasterDataSubModuleProvider<T> subModuleProvider) {
        this.subModuleProvider = subModuleProvider;
    }

    public Class<AMasterDataComplete> getExportClass() {
        return this.getSubModuleProvider().getExportClass();
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public String getTitleString() {
        return null;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }
}

