/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.mealplan.articles;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.List;

public class AnalysisMealPlanArticlesComponent
extends DefaultServerSideAnalysisComponent<MealPlanLight, MealPlanReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<CheckBox> includeAll;

    public AnalysisMealPlanArticlesComponent(AnalysisSmartExternalOpenTool<MealPlanLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        boolean canExportCosts = ProductToolkit.canExportMealPlanProductCosts();
        if (canExportCosts) {
            this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.showCosts, "costs"));
        }
        this.includeAll = new TitledItem<CheckBox>(new CheckBox(), "Include all", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAll, "includeAll"));
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_USAGE;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public MealPlanReference createReference(MealPlanLight item) {
        return new MealPlanReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        Date date = null;
        date = (Date)this.validityDate.getElement().getNode().getValue();
        List references = this.loadItemReferences();
        PegasusFileComplete file = (PegasusFileComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlanArticlesReport(new ListWrapper(references), new TimestampWrapper(date.getTime()), this.showCosts != null ? this.showCosts.getElement().isChecked() : false, this.includeAll.getElement().isChecked()).getValue();
        return file;
    }
}

