/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.articleexport;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.ProductTable;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExportProductArticlesComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private ProductTable products;
    private TitledItem<DateChooser> dateChooser;
    private TitledItem<CheckBox> showCosts;
    private boolean canExportCosts = ProductToolkit.canExportProductCosts(false);

    public ExportProductArticlesComponent() {
        super(false, false, false, false, ReportTypeE.PRODUCT_ARTICLES_REPORT);
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (!n.equals("bonded")) continue;
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.products);
        CheckedListAdder.addToList(focusList, this.dateChooser);
        CheckedListAdder.addToList(focusList, this.showCosts);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.products = new ProductTable();
        this.products.getModel().setNode((Node)new ViewNode(""));
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        n.setName(DtoFieldConstants.selectedDate);
        this.products.setValidityNode(n);
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(n), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        if (this.canExportCosts) {
            this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.getViewContainer().add(this.showCosts);
        }
        this.getViewContainer().add(this.products);
        this.getViewContainer().add(this.dateChooser);
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCTS;
    }

    @Override
    public String getTitleValue() {
        return Words.EXPORT;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.products != null) {
            this.products.kill();
        }
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        if (this.showCosts != null) {
            this.showCosts.kill();
        }
        this.products = null;
        this.dateChooser = null;
        this.showCosts = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.products != null) {
            this.products.setVisible(true);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
        if (this.showCosts != null) {
            this.showCosts.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.products != null) {
            this.products.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
        if (this.showCosts != null) {
            this.showCosts.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> objects;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.products != null && this.products.getModel().getNode().getChildCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_PRODUCT));
        }
        if ((objects = super.validateBeforePrint()) != null) {
            validationObjects.addAll(objects);
        }
        return validationObjects;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node node = ExportProductArticlesComponent.this.products.getModel().getNode();
                ArrayList<ProductVariantReference> variants = new ArrayList<ProductVariantReference>();
                Iterator it = node.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue() == null) continue;
                    variants.add(new ProductVariantReference(((ProductVariantLight)n.getValue()).getId()));
                }
                Date d = (Date)((DateChooser)ExportProductArticlesComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductArticlesReport(new ListWrapper(variants), new TimestampWrapper(d.getTime()), ExportProductArticlesComponent.this.showCosts != null ? ((CheckBox)ExportProductArticlesComponent.this.showCosts.getElement()).isChecked() : false).getValue();
                ExportProductArticlesComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportProductArticlesComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportProductArticlesComponent.this.layoutInheritedComponents(parent);
            if (ExportProductArticlesComponent.this.products != null) {
                ExportProductArticlesComponent.this.products.setLocation(ExportProductArticlesComponent.this.border, y);
                ExportProductArticlesComponent.this.products.setSize(parent.getWidth() - 2 * ExportProductArticlesComponent.this.border, (int)((double)parent.getHeight() - ((double)(2 * y + ExportProductArticlesComponent.this.border) + ExportProductArticlesComponent.this.dateChooser.getPreferredSize().getHeight())));
                y = ExportProductArticlesComponent.this.products.getY() + ExportProductArticlesComponent.this.products.getHeight() + ExportProductArticlesComponent.this.border;
            }
            if (ExportProductArticlesComponent.this.dateChooser != null) {
                ExportProductArticlesComponent.this.dateChooser.setLocation(ExportProductArticlesComponent.this.border, y);
                ExportProductArticlesComponent.this.dateChooser.setSize(ExportProductArticlesComponent.this.dateChooser.getPreferredSize());
                y = ExportProductArticlesComponent.this.dateChooser.getY() + ExportProductArticlesComponent.this.dateChooser.getHeight() + ExportProductArticlesComponent.this.border;
            }
            if (ExportProductArticlesComponent.this.showCosts != null) {
                ExportProductArticlesComponent.this.showCosts.setLocation(ExportProductArticlesComponent.this.border, y);
                ExportProductArticlesComponent.this.showCosts.setSize(ExportProductArticlesComponent.this.showCosts.getPreferredSize());
                y += ExportProductArticlesComponent.this.showCosts.getY() + ExportProductArticlesComponent.this.showCosts.getHeight() + ExportProductArticlesComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportProductArticlesComponent.this.getInheritedComponentsHeight();
            h += ExportProductArticlesComponent.this.border;
            if (ExportProductArticlesComponent.this.products != null) {
                h += 200;
                h += ExportProductArticlesComponent.this.border;
            }
            if (ExportProductArticlesComponent.this.dateChooser != null) {
                h = (int)((double)h + ExportProductArticlesComponent.this.dateChooser.getPreferredSize().getHeight());
                h += ExportProductArticlesComponent.this.border;
            }
            if (ExportProductArticlesComponent.this.showCosts != null) {
                h = (int)((double)h + ExportProductArticlesComponent.this.showCosts.getPreferredSize().getHeight());
                h += ExportProductArticlesComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

