/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.mplfactsheets;

import ch.icit.pegasus.client.gui.submodules.analysis.product.remote.mplfactsheets.AnalysisMPLProductFactSheetReport;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.List;

public class AnalysisMPLProductFactSheetComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;
    private TitledItem<CheckBox> resolveCatalog;
    private TitledItem<CheckBox> resolveSoldQty;
    private TitledItem<CheckBox> includeCancelledFlights;
    private TitledItem<CheckBox> useSeparatePeriodForProducts;
    private TitledPeriodEditor productsPeriod;

    public AnalysisMPLProductFactSheetComponent(AnalysisMPLProductFactSheetReport productListAnalysis) {
        super(productListAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), false, false), null);
        this.resolveCatalog = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_CATALOG, TitledItem.TitledItemOrientation.EAST);
        this.resolveSoldQty = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_QTY, TitledItem.TitledItemOrientation.EAST);
        this.resolveSoldQty.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.includeCancelledFlights = new TitledItem<CheckBox>(new CheckBox(), "Include cancelled Flights", TitledItem.TitledItemOrientation.EAST);
        this.useSeparatePeriodForProducts = new TitledItem<CheckBox>(new CheckBox(), "Use separate period for products", TitledItem.TitledItemOrientation.EAST);
        this.productsPeriod = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), false, false), null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.period, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveCatalog, "resolveCatalog"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveSoldQty, "resolveQty"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCancelledFlights, "includeCancelledFlights"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.useSeparatePeriodForProducts, "separateProductPeriod"));
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.productsPeriod, "productPeriod"));
        this.useSeparatePeriodForProducts.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.productsPeriod.setEnabled(enabled && this.useSeparatePeriodForProducts.getElement().isChecked());
        this.includeCancelledFlights.setEnabled(enabled && this.resolveSoldQty.getElement().isChecked());
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        PeriodComplete period = this.period.getPeriod();
        PeriodComplete productPeriod = this.productsPeriod.getPeriod();
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createMPLProductFactSheetExportForProducts(new ListWrapper(references), this.resolveCatalog.getElement().isChecked(), this.resolveSoldQty.getElement().isChecked(), this.includeCancelledFlights.getElement().isChecked(), period, Boolean.valueOf(this.useSeparatePeriodForProducts.getElement().isChecked()), productPeriod).getValue();
        return file;
    }
}

