/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.picknpay.articlecost;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.PickNPayServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisProductExportArticleCostComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public AnalysisProductExportArticleCostComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.PICK_N_PAY_PRICE_LIST;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        PegasusFileComplete file = (PegasusFileComplete)((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).createArticleCostUpload(new ListWrapper(references), new DateWrapper(date)).getValue();
        return file;
    }
}

