/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.salesforecast;

import ch.icit.pegasus.client.converter.ProductVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ProductForecastFactorTable
extends Table2
implements NodeListener {
    private static final long serialVersionUID = 1L;

    public ProductForecastFactorTable() {
        super(false, "", true, false);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ProductForecastFactorTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node node = new Node();
                DTOProxyNode pNode = new DTOProxyNode();
                pNode.setName("product");
                Node fNode = new Node();
                fNode.setName("factor");
                fNode.setValue((Object)0.0, 0L);
                node.addChild((Node)pNode, 0L);
                node.addChild(fNode, 0L);
                ProductForecastFactorTable.this.getModel().getNode().addChild(node, 0L);
                ProductForecastFactorTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.FACTOR, null, null, null, "", 100, 100, 100));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel productSearch;
        private TextField factorField;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.productSearch = new TextLabel(m.getNode().getChildNamed(new String[]{"product", ProductComplete_.currentVariant.getName()}), ConverterRegistry.getConverter(ProductVariantConverter.class));
            this.factorField = new TextField(m.getNode().getChildNamed(new String[]{"factor"}), TextFieldType.DOUBLE);
            this.setLayout(new Layout());
            this.add(this.productSearch);
            this.add(this.factorField);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.productSearch.kill();
            this.factorField.kill();
            this.productSearch = null;
            this.factorField = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.factorField.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.productSearch.setEnabled(isEnabled);
            this.factorField.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.factorField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.factorField.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.factorField.setSize(TableRowImpl.this.factorField.getPreferredSize());
            }
        }
    }
}

