/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.documentscan;

import ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.documentscan.DocumentDownloadAnalysis;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import java.io.File;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;

public class DocumentDownloadAnalysisComponent
extends DefaultServerSideAnalysisComponent<PurchaseOrderLight, PurchaseOrderReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> filterBonded;

    public DocumentDownloadAnalysisComponent(DocumentDownloadAnalysis documentDownloadAnalysis) {
        super(documentDownloadAnalysis);
    }

    @Override
    public void addOptionItems() {
    }

    @Override
    public PurchaseOrderReference createReference(PurchaseOrderLight item) {
        return new PurchaseOrderReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        File folder = FileChooserUtil.saveFileToFolder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd");
        for (PurchaseOrderReference loadItemReference : this.loadItemReferences()) {
            PurchaseOrderComplete order = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(loadItemReference).getValue();
            int count = 1;
            for (PurchaseOrderReceivingGroupComplete group : order.getCheckinGroups()) {
                if (group.getDocumentScan() == null || group.getDocumentScan().getFileData() == null) continue;
                File file = FileTransferUtil.download((PegasusFileComplete)group.getDocumentScan().getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                String targetFileName = "" + order.getNumber() + "_" + order.getSupplier().getName().replaceAll(" ", "_").toLowerCase() + "_" + count + "_" + df.format(order.getDeliveryDate()) + ".pdf";
                FileUtils.moveFile((File)file, (File)new File(folder.getAbsolutePath() + File.separator + targetFileName));
                ++count;
            }
        }
        return null;
    }
}

