/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.kpi;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.KPIAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import java.sql.Date;

public class KPIAnalysisComponent
extends AsynchronusAnalysisPopupInsert<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private boolean hl1;
    private boolean hl2;
    private boolean receive;
    private TitledPeriodEditor periodEditor;
    private TitledItem<CheckBox> includeHL1;
    private TitledItem<CheckBox> includeHL2;
    private TitledItem<CheckBox> includeReceive;
    private TitledItem<CheckBox> showDetails;

    public KPIAnalysisComponent(AnalysisSmartExternalOpenTool<PurchaseOrderLight> subProv) {
        super(subProv, false, false, null, false);
    }

    @Override
    public void addOptionItems() {
        this.hl1 = this.externalOpenTool.getCurrentRDProvider().isWritable(PurchaseOrderAccess.SCM_KPI_HL1);
        this.hl2 = this.externalOpenTool.getCurrentRDProvider().isWritable(PurchaseOrderAccess.SCM_KPI_HL1);
        this.receive = this.externalOpenTool.getCurrentRDProvider().isWritable(PurchaseOrderAccess.SCM_KPI_HL1);
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node pNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledPeriodEditor((Node<Date>)pNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)pNode.getChildNamed(PeriodComplete_.endDate), true, null);
        if (this.hl1) {
            this.includeHL1 = new TitledItem<CheckBox>(new CheckBox(), "Include HL 1", TitledItem.TitledItemOrientation.EAST);
        }
        if (this.hl2) {
            this.includeHL2 = new TitledItem<CheckBox>(new CheckBox(), "Include HL 2", TitledItem.TitledItemOrientation.EAST);
        }
        if (this.receive) {
            this.includeReceive = new TitledItem<CheckBox>(new CheckBox(), "Include Receive", TitledItem.TitledItemOrientation.EAST);
        }
        this.showDetails = new TitledItem<CheckBox>(new CheckBox(), "Show Details", TitledItem.TitledItemOrientation.EAST);
        if (this.hl1) {
            this.includeHL1.getElement().setChecked(true);
        }
        if (this.hl2) {
            this.includeHL2.getElement().setChecked(true);
        }
        if (this.receive) {
            this.includeReceive.getElement().setChecked(true);
        }
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.periodEditor, "period"));
        if (this.hl1) {
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHL1, "includeHL1"));
        }
        if (this.hl2) {
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHL2, "includeHL2"));
        }
        if (this.receive) {
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeReceive, "includeReceive"));
        }
        this.addOptionsItem(new CheckBoxAnalysisItem(this.showDetails, "showDetails"));
    }

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KPIAnalysisComponent.this.writeConfigurationValues();
                KPIAnalysisReportConfiguration reportConfiguration = (KPIAnalysisReportConfiguration)KPIAnalysisComponent.this.getReportConfiguration();
                PegasusFileComplete ret = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createSCMKPI(reportConfiguration).getValue();
                KPIAnalysisComponent.this.ensureAnimation("Downloading");
                PegasusFileComplete res = ret;
                if (res == null) {
                    KPIAnalysisComponent.this.nullReturned();
                    return null;
                }
                KPIAnalysisComponent.this.processPegasusFile(res);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return KPIAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        KPIAnalysisReportConfiguration config = new KPIAnalysisReportConfiguration();
        config.setPeriod(this.periodEditor.getPeriod());
        if (this.hl1) {
            config.setIncludeHL1(Boolean.valueOf(this.includeHL1.getElement().isChecked()));
        }
        if (this.hl2) {
            config.setIncludeHL2(Boolean.valueOf(this.includeHL2.getElement().isChecked()));
        }
        if (this.receive) {
            config.setIncludeReceive(Boolean.valueOf(this.includeReceive.getElement().isChecked()));
        }
        config.setShowDetails(Boolean.valueOf(this.showDetails.getElement().isChecked()));
        return config;
    }
}

