/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.oprp;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.PurchaseHACCPAnalysisReportConfiguration;
import java.sql.Date;

public class OPRPCheckAnalysisComponent
extends AsynchronusAnalysisPopupInsert<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor periodEditor;
    private TitledItem<CheckBox> includeHistory;

    public OPRPCheckAnalysisComponent(AnalysisSmartExternalOpenTool<PurchaseOrderLight> subProv) {
        super(subProv, false, false, null, false);
    }

    @Override
    public void addOptionItems() {
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node pNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledPeriodEditor((Node<Date>)pNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)pNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.includeHistory = new TitledItem<CheckBox>(new CheckBox(), "Include History", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.periodEditor, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHistory, "include_history"));
    }

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                OPRPCheckAnalysisComponent.this.writeConfigurationValues();
                PurchaseHACCPAnalysisReportConfiguration reportConfiguration = (PurchaseHACCPAnalysisReportConfiguration)OPRPCheckAnalysisComponent.this.getReportConfiguration();
                reportConfiguration.setHaccpSystem(Boolean.valueOf(false));
                PegasusFileComplete report = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createHACCPCheckReport(reportConfiguration).getValue();
                OPRPCheckAnalysisComponent.this.ensureAnimation("Downloading");
                PegasusFileComplete res = report;
                if (res == null) {
                    OPRPCheckAnalysisComponent.this.nullReturned();
                    return null;
                }
                OPRPCheckAnalysisComponent.this.processPegasusFile(res);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return OPRPCheckAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        PurchaseHACCPAnalysisReportConfiguration a = new PurchaseHACCPAnalysisReportConfiguration();
        a.setIncludeHistory(Boolean.valueOf(this.includeHistory.getElement().isChecked()));
        a.setPeriod(this.periodEditor.getPeriod());
        return a;
    }
}

