/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.sob.productsales;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class AnalysisProductSalesComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeDetails;
    private TitledItem<CheckBox> byProductVariant;

    public AnalysisProductSalesComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.includeDetails = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALL_SALE_TYPES, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeDetails, "details"));
        this.byProductVariant = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_BY_VARIANT, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.byProductVariant, "productVariant"));
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_SALES;
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        return new FlightReference(item.getId());
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        PeriodComplete date = null;
        if (!((RadioButton)this.exportCurrent.getElement()).isChecked()) {
            date = ((FlightSearchConfiguration)this.getSearchConfiguration()).getDayPeriod();
        }
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobProductSales(new ListWrapper(references), date, this.includeDetails.getElement().isChecked(), !this.byProductVariant.getElement().isChecked()).getValue();
        return file;
    }
}

