/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.store.actualstock;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExportStoreStockComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockReportConfiguration> stockConfig;
    private TitledItem<CheckBox> allStores;
    private StoreSearchTable stores;
    private HorizontalSeparator sep6;
    private TextLabel options;
    private TitledItem<CheckBox> includeSupplierArticleNumber;
    private TitledItem<SearchTextField2<SupplierLight>> supplierSearchField;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<CheckBox> includeCustomerData;
    private TitledItem<CheckBox> includeCustomerOwnedArticles;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearch;

    public ExportStoreStockComponent() {
        super(false, false, false, false, ReportTypeE.STOCK_EXPORT);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (!n.equals("bonded")) continue;
        }
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.allStores);
        CheckedListAdder.addToList(focusList, this.stores);
        CheckedListAdder.addToList(focusList, this.includeSupplierArticleNumber);
        CheckedListAdder.addToList(focusList, this.supplierSearchField);
        CheckedListAdder.addToList(focusList, this.filterBonded);
        CheckedListAdder.addToList(focusList, this.customerSearch);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        StockReportConfiguration config = new StockReportConfiguration();
        this.stockConfig = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.createComponents();
        this.allStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.stockConfig.getChildNamed(StockReportConfiguration_.printAllStores)), Words.INCLUDE_ALL_STORES, TitledItem.TitledItemOrientation.EAST);
        this.stores = new StoreSearchTable();
        this.stores.getModel().setNode(this.stockConfig.getChildNamed(StockReportConfiguration_.includedStores));
        this.sep6 = new HorizontalSeparator();
        Font titleFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type"));
        Color titleColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground"));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(titleFont);
        this.options.setForeground(titleColor);
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(this.stockConfig.getChildNamed(StockReportConfiguration_.bonded), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.filterBonded.getTitle().setForeground(fb);
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.stockConfig.getChildNamed(StockReportConfiguration_.includeCustomerData)), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.includeCustomerOwnedArticles = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.stockConfig.getChildNamed(StockReportConfiguration_.includeCustomerArticle)), Words.INCLUDE_CUSTOMER_OWNED, TitledItem.TitledItemOrientation.EAST);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.stockConfig.getChildNamed(StockReportConfiguration_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.includeSupplierArticleNumber = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE_SUPPLIER_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.supplierSearchField = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, this.stockConfig.getChildNamed(StockReportConfiguration_.supplier)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.allStores);
        this.getViewContainer().add(this.stores);
        this.getViewContainer().add(this.sep6);
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.filterBonded);
        this.getViewContainer().add(this.includeCustomerData);
        this.getViewContainer().add(this.includeCustomerOwnedArticles);
        this.getViewContainer().add(this.customerSearch);
        this.getViewContainer().add(this.includeSupplierArticleNumber);
        this.getViewContainer().add(this.supplierSearchField);
    }

    @Override
    public String getTitleString() {
        return Words.STORES;
    }

    @Override
    public String getTitleValue() {
        return Words.EXPORT;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.allStores != null) {
            this.allStores.kill();
        }
        if (this.stores != null) {
            this.stores.kill();
        }
        if (this.sep6 != null) {
            this.sep6.kill();
        }
        if (this.options != null) {
            this.options.kill();
        }
        if (this.filterBonded != null) {
            this.filterBonded.kill();
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        if (this.includeCustomerOwnedArticles != null) {
            this.includeCustomerOwnedArticles.kill();
        }
        if (this.customerSearch != null) {
            this.customerSearch.kill();
        }
        if (this.includeSupplierArticleNumber != null) {
            this.includeSupplierArticleNumber.kill();
        }
        if (this.supplierSearchField != null) {
            this.supplierSearchField.kill();
        }
        this.includeSupplierArticleNumber = null;
        this.supplierSearchField = null;
        this.customerSearch = null;
        this.includeCustomerOwnedArticles = null;
        this.allStores = null;
        this.stores = null;
        this.sep6 = null;
        this.options = null;
        this.filterBonded = null;
        this.includeCustomerData = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.allStores != null) {
            this.allStores.setVisible(true);
        }
        if (this.stores != null) {
            this.stores.setVisible(true);
        }
        if (this.sep6 != null) {
            this.sep6.setVisible(true);
        }
        if (this.options != null) {
            this.options.setVisible(true);
        }
        if (this.filterBonded != null) {
            this.filterBonded.setVisible(true);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(true);
        }
        if (this.includeCustomerOwnedArticles != null) {
            this.includeCustomerOwnedArticles.setVisible(true);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(true);
        }
        if (this.includeSupplierArticleNumber != null) {
            this.includeSupplierArticleNumber.setVisible(true);
        }
        if (this.supplierSearchField != null) {
            this.supplierSearchField.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.allStores != null) {
            this.allStores.setVisible(false);
        }
        if (this.stores != null) {
            this.stores.setVisible(false);
        }
        if (this.sep6 != null) {
            this.sep6.setVisible(false);
        }
        if (this.options != null) {
            this.options.setVisible(false);
        }
        if (this.filterBonded != null) {
            this.filterBonded.setVisible(false);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(false);
        }
        if (this.includeCustomerOwnedArticles != null) {
            this.includeCustomerOwnedArticles.setVisible(false);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(false);
        }
        if (this.includeSupplierArticleNumber != null) {
            this.includeSupplierArticleNumber.setVisible(false);
        }
        if (this.supplierSearchField != null) {
            this.supplierSearchField.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> objectList;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (!this.allStores.getElement().isChecked() && this.stores != null && this.stores.getModel().getNode().getChildCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_STORE));
        }
        if ((objectList = super.validateBeforePrint()) != null) {
            validationObjects.addAll(objectList);
        }
        return validationObjects;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportStoreStockComponent.this.stockConfig.commit();
                StockReportConfiguration config = (StockReportConfiguration)ExportStoreStockComponent.this.stockConfig.getValue();
                config.setFormat(ReportingOutputFormatE.XLS);
                if (((CheckBox)ExportStoreStockComponent.this.allStores.getElement()).isChecked()) {
                    config.setPrintAllStores(Boolean.valueOf(true));
                } else {
                    ArrayList<StoreReference> includedStores = new ArrayList<StoreReference>();
                    Iterator it = ExportStoreStockComponent.this.stores.getModel().getNode().getChilds();
                    while (it.hasNext()) {
                        Node store = (Node)it.next();
                        includedStores.add(new StoreReference(((StoreLight)store.getValue()).getId()));
                    }
                    config.setIncludedStores(includedStores);
                }
                config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)ExportStoreStockComponent.this.includeCustomerData.getElement()).isChecked()));
                config.setIncludeCustomerArticle(Boolean.valueOf(((CheckBox)ExportStoreStockComponent.this.includeCustomerOwnedArticles.getElement()).isChecked()));
                config.setCustomer((CustomerReference)((SearchTextField2)ExportStoreStockComponent.this.customerSearch.getElement()).getNode().getValue());
                config.setIncludeArticleSupplierNumber(Boolean.valueOf(((CheckBox)ExportStoreStockComponent.this.includeSupplierArticleNumber.getElement()).isChecked()));
                config.setSupplier((SupplierReference)((SearchTextField2)ExportStoreStockComponent.this.supplierSearchField.getElement()).getNode().getValue());
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createActualStockReport(config).getValue();
                ExportStoreStockComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportStoreStockComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportStoreStockComponent.this.layoutInheritedComponents(parent);
            if (ExportStoreStockComponent.this.allStores != null) {
                ExportStoreStockComponent.this.allStores.setLocation(ExportStoreStockComponent.this.border, y + ExportStoreStockComponent.this.border);
                ExportStoreStockComponent.this.allStores.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.allStores.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.allStores.getY() + ExportStoreStockComponent.this.allStores.getHeight() + ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.stores != null) {
                ExportStoreStockComponent.this.stores.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.stores.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, 200);
                y = ExportStoreStockComponent.this.stores.getY() + ExportStoreStockComponent.this.stores.getHeight() + ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.sep6 != null) {
                ExportStoreStockComponent.this.sep6.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.sep6.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.sep6.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.sep6.getY() + ExportStoreStockComponent.this.sep6.getHeight() + ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.options != null) {
                ExportStoreStockComponent.this.options.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.options.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.options.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.options.getY() + ExportStoreStockComponent.this.options.getHeight() + ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.filterBonded != null) {
                ExportStoreStockComponent.this.filterBonded.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.filterBonded.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.filterBonded.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.filterBonded.getY() + ExportStoreStockComponent.this.filterBonded.getHeight() + ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.includeCustomerData != null) {
                ExportStoreStockComponent.this.includeCustomerData.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.includeCustomerData.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.includeCustomerData.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.includeCustomerData.getY() + ExportStoreStockComponent.this.includeCustomerData.getHeight() + ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.includeCustomerOwnedArticles != null) {
                ExportStoreStockComponent.this.includeCustomerOwnedArticles.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.includeCustomerOwnedArticles.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.includeCustomerOwnedArticles.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.includeCustomerOwnedArticles.getY() + ExportStoreStockComponent.this.includeCustomerOwnedArticles.getHeight() + ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.customerSearch != null) {
                ExportStoreStockComponent.this.customerSearch.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.customerSearch.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.customerSearch.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.customerSearch.getY() + ExportStoreStockComponent.this.customerSearch.getHeight() + ExportStoreStockComponent.this.border * 2;
            }
            if (ExportStoreStockComponent.this.includeSupplierArticleNumber != null) {
                ExportStoreStockComponent.this.includeSupplierArticleNumber.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.includeSupplierArticleNumber.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.includeSupplierArticleNumber.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.includeSupplierArticleNumber.getY() + ExportStoreStockComponent.this.includeSupplierArticleNumber.getHeight();
            }
            if (ExportStoreStockComponent.this.supplierSearchField != null) {
                ExportStoreStockComponent.this.supplierSearchField.setLocation(ExportStoreStockComponent.this.border, y);
                ExportStoreStockComponent.this.supplierSearchField.setSize(parent.getWidth() - 2 * ExportStoreStockComponent.this.border, (int)ExportStoreStockComponent.this.supplierSearchField.getPreferredSize().getHeight());
                y = ExportStoreStockComponent.this.supplierSearchField.getY() + ExportStoreStockComponent.this.supplierSearchField.getHeight() + ExportStoreStockComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportStoreStockComponent.this.getInheritedComponentsHeight();
            h += ExportStoreStockComponent.this.border;
            if (ExportStoreStockComponent.this.allStores != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.allStores.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.stores != null) {
                h += 200;
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.sep6 != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.sep6.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.options != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.options.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.filterBonded != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.filterBonded.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border / 2;
            }
            if (ExportStoreStockComponent.this.includeCustomerData != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.includeCustomerData.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.includeCustomerOwnedArticles != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.includeCustomerOwnedArticles.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.customerSearch != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.customerSearch.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.includeSupplierArticleNumber != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.includeSupplierArticleNumber.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            if (ExportStoreStockComponent.this.supplierSearchField != null) {
                h = (int)((double)h + ExportStoreStockComponent.this.supplierSearchField.getPreferredSize().getHeight());
                h += ExportStoreStockComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

