/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.store.barcode.article;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExportStoreBarcodeComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockReportConfiguration> stockConfig;
    private TitledItem<CheckBox> allStores;
    private StoreSearchTable stores;
    private HorizontalSeparator sep6;

    public ExportStoreBarcodeComponent() {
        super(false, false, false, false, ReportTypeE.STOCK_EXPORT);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.allStores);
        CheckedListAdder.addToList(focusList, this.stores);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        StockReportConfiguration config = new StockReportConfiguration();
        this.stockConfig = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.createComponents();
        this.allStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.stockConfig.getChildNamed(StockReportConfiguration_.printAllStores)), Words.INCLUDE_ALL_STORES, TitledItem.TitledItemOrientation.EAST);
        this.stores = new StoreSearchTable();
        this.stores.getModel().setNode(this.stockConfig.getChildNamed(StockReportConfiguration_.includedStores));
        this.sep6 = new HorizontalSeparator();
        this.getViewContainer().add(this.allStores);
        this.getViewContainer().add(this.stores);
        this.getViewContainer().add(this.sep6);
    }

    @Override
    public String getTitleString() {
        return Words.STORES;
    }

    @Override
    public String getTitleValue() {
        return Words.BAR_CODE;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.allStores != null) {
            this.allStores.kill();
        }
        if (this.stores != null) {
            this.stores.kill();
        }
        if (this.sep6 != null) {
            this.sep6.kill();
        }
        this.allStores = null;
        this.stores = null;
        this.sep6 = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.allStores != null) {
            this.allStores.setVisible(true);
        }
        if (this.stores != null) {
            this.stores.setVisible(true);
        }
        if (this.sep6 != null) {
            this.sep6.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.allStores != null) {
            this.allStores.setVisible(false);
        }
        if (this.stores != null) {
            this.stores.setVisible(false);
        }
        if (this.sep6 != null) {
            this.sep6.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> objectList;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (!this.allStores.getElement().isChecked() && this.stores != null && this.stores.getModel().getNode().getChildCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_STORE));
        }
        if ((objectList = super.validateBeforePrint()) != null) {
            validationObjects.addAll(objectList);
        }
        return validationObjects;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportStoreBarcodeComponent.this.stockConfig.commit();
                StockReportConfiguration config = (StockReportConfiguration)ExportStoreBarcodeComponent.this.stockConfig.getValue();
                config.setFormat(ReportingOutputFormatE.PDF);
                ListWrapper reps = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportStylesheets(ReportTypeE.STORE_BARCODE);
                if (!reps.getList().isEmpty()) {
                    config.setStylesheet((ReportFileComplete)reps.getList().get(0));
                }
                if (((CheckBox)ExportStoreBarcodeComponent.this.allStores.getElement()).isChecked()) {
                    config.setPrintAllStores(Boolean.valueOf(true));
                } else {
                    ArrayList<StoreReference> includedStores = new ArrayList<StoreReference>();
                    Iterator it = ExportStoreBarcodeComponent.this.stores.getModel().getNode().getChilds();
                    while (it.hasNext()) {
                        Node store = (Node)it.next();
                        includedStores.add(new StoreReference(((StoreLight)store.getValue()).getId()));
                    }
                    config.setIncludedStores(includedStores);
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createStockBarcode(config).getValue();
                ExportStoreBarcodeComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportStoreBarcodeComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportStoreBarcodeComponent.this.layoutInheritedComponents(parent);
            if (ExportStoreBarcodeComponent.this.allStores != null) {
                ExportStoreBarcodeComponent.this.allStores.setLocation(ExportStoreBarcodeComponent.this.border, y + ExportStoreBarcodeComponent.this.border);
                ExportStoreBarcodeComponent.this.allStores.setSize(parent.getWidth() - 2 * ExportStoreBarcodeComponent.this.border, (int)ExportStoreBarcodeComponent.this.allStores.getPreferredSize().getHeight());
                y = ExportStoreBarcodeComponent.this.allStores.getY() + ExportStoreBarcodeComponent.this.allStores.getHeight() + ExportStoreBarcodeComponent.this.border / 2;
            }
            if (ExportStoreBarcodeComponent.this.stores != null) {
                ExportStoreBarcodeComponent.this.stores.setLocation(ExportStoreBarcodeComponent.this.border, y);
                ExportStoreBarcodeComponent.this.stores.setSize(parent.getWidth() - 2 * ExportStoreBarcodeComponent.this.border, 400);
                y = ExportStoreBarcodeComponent.this.stores.getY() + ExportStoreBarcodeComponent.this.stores.getHeight() + ExportStoreBarcodeComponent.this.border;
            }
            if (ExportStoreBarcodeComponent.this.sep6 != null) {
                ExportStoreBarcodeComponent.this.sep6.setLocation(ExportStoreBarcodeComponent.this.border, y);
                ExportStoreBarcodeComponent.this.sep6.setSize(parent.getWidth() - 2 * ExportStoreBarcodeComponent.this.border, (int)ExportStoreBarcodeComponent.this.sep6.getPreferredSize().getHeight());
                y = ExportStoreBarcodeComponent.this.sep6.getY() + ExportStoreBarcodeComponent.this.sep6.getHeight() + ExportStoreBarcodeComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportStoreBarcodeComponent.this.getInheritedComponentsHeight();
            h += ExportStoreBarcodeComponent.this.border;
            if (ExportStoreBarcodeComponent.this.allStores != null) {
                h = (int)((double)h + ExportStoreBarcodeComponent.this.allStores.getPreferredSize().getHeight());
                h += ExportStoreBarcodeComponent.this.border / 2;
            }
            if (ExportStoreBarcodeComponent.this.stores != null) {
                h += 200;
                h += ExportStoreBarcodeComponent.this.border;
            }
            if (ExportStoreBarcodeComponent.this.sep6 != null) {
                h = (int)((double)h + ExportStoreBarcodeComponent.this.sep6.getPreferredSize().getHeight());
                h += ExportStoreBarcodeComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

