/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.store.transactions.article;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.StoreTransactionAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class TransactionsAnalysisComponent
extends AsynchronusAnalysisPopupInsert<StoreLight> {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser period;
    private TitledItem<CheckBox> includeCustomerData;

    public TransactionsAnalysisComponent(AnalysisSmartExternalOpenTool<StoreLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        TimestampPeriodComplete p = new TimestampPeriodComplete();
        p.setStartTime(new Timestamp(System.currentTimeMillis()));
        p.setEndTime(new Timestamp(System.currentTimeMillis()));
        this.period = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false));
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateTimePeriodEditorAnalysisItem(this.period, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCustomerData, "customerData"));
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        StoreTransactionAnalysisReportConfiguration conf = new StoreTransactionAnalysisReportConfiguration();
        conf.setIncludeCustomerData(this.includeCustomerData.getElement().isChecked());
        TimestampPeriodComplete p = this.period.getTimePeriod();
        conf.setPeriodStartDate(p.getStartTime());
        conf.setPeriodEndDate(p.getEndTime());
        return conf;
    }
}

