/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.stowinglisttemplate.spec;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.GenericStowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;

public class StowingListSpecExportAnalysisComponent
extends AsyncSimpleExportPopupInsert<StowingListTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> includeStowingListConfig;
    private TitledItem<CheckBox> includeMealPlan;
    private TitledItem<CheckBox> includeAllVariants;

    public StowingListSpecExportAnalysisComponent(AnalysisSmartExternalOpenTool<StowingListTemplateComplete> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node dn = new Node();
        dn.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dn), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.includeStowingListConfig = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOWING_LIST_CONFIG, TitledItem.TitledItemOrientation.EAST);
        this.includeStowingListConfig.setTitleFont(f);
        this.includeStowingListConfig.setTitleForeground(fb);
        this.includeMealPlan = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN, TitledItem.TitledItemOrientation.EAST);
        this.includeMealPlan.setTitleFont(f);
        this.includeMealPlan.setTitleForeground(fb);
        this.includeAllVariants = new TitledItem<CheckBox>(new CheckBox(), "Include all Variants", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStowingListConfig, "includeStowingConfiguration"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeMealPlan, "includeMealPlan"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllVariants, "allVariants"));
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.StowingListSpecs;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        GenericStowingListReportConfiguration conf = new GenericStowingListReportConfiguration();
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        conf.setDueDate(new Timestamp(date.getTime()));
        conf.setReportType(this.getReportType());
        conf.setIncludeAllVariants(Boolean.valueOf(this.includeAllVariants.getElement().isChecked()));
        conf.setIncludeMealPlan(Boolean.valueOf(this.includeMealPlan.getElement().isChecked()));
        conf.setIncludeStowingListConfiguration(Boolean.valueOf(this.includeStowingListConfig.getElement().isChecked()));
        return conf;
    }
}

