/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.stowinglisttemplate.usage;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisStowingUsageComponent
extends DefaultServerSideAnalysisComponent<StowingListTemplateComplete, StowingListTemplateReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public AnalysisStowingUsageComponent(AnalysisSmartExternalOpenTool<StowingListTemplateComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.FROM, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.STOWING_LIST_USAGE;
    }

    @Override
    public String getTitleValue() {
        return Words.STOWING_LIST;
    }

    @Override
    public StowingListTemplateReference createReference(StowingListTemplateComplete item) {
        return new StowingListTemplateReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        ArrayList<StowingListTemplateReference> references = new ArrayList<StowingListTemplateReference>();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            StowingListTemplateReference v = (StowingListTemplateReference)s.next();
            references.add(v);
        }
        return (PegasusFileComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).printStowingTemplateUsage(new ListWrapper(references), new DateWrapper(date.getTime())).getValue();
    }
}

