/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.twm.remote.orders;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.twm.TWMOrdersExportConfiguration;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ThreeWayMatchPeriodOrderAnalysisComponent
extends DefaultScrollablePrintPopup2<ThreeWayMatchLight> {
    private static final long serialVersionUID = 1L;
    private Node<TWMOrdersExportConfiguration> configNode;
    private TitledPeriodEditor periodEditor;
    private TitledItem<TextField> numberChooser;
    private RadioButton choosePeriod;
    private RadioButton chooseNumbers;
    private TitledItem<CheckBox> useOnlyAttachedOrders;
    private InfoButton numberChooserInfo;
    private HorizontalSeparator sep1;
    private TitledItem<CheckBox> includeSummary;
    private TitledItem<CheckBox> includeSupplierOverview;
    private TitledItem<CheckBox> includeAllOrders;
    private TitledItem<CheckBox> includeApprovedOrders;
    private TitledItem<CheckBox> includeNotApprovedOrders;
    private TitledItem<CheckBox> includeNotCheckedOrders;
    private TitledItem<ComboBox> sortBy;
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String INCLUDE_SUMMARY = "includeSummary";
    public static final String INCLUDE_SUPPLIER_OVERIVEW = "includeSupplierOverview";
    public static final String INCLUDE_ALL_ORDERS = "includeAllOrders";
    public static final String INCLUDE_APPROVED_ORDERS = "includeApprovedOrders";
    public static final String INCLUDE_NOT_APPROVED_ORDERS = "includeNotApprovedOrders";
    public static final String INCLUDE_NOT_CHECKED_ORDERS = "includeNotCheckedOrders";
    public static final String USE_ONLY_ATTACHED_ORDERS = "showOnlyAttachedOrders";

    public ThreeWayMatchPeriodOrderAnalysisComponent() {
        super(false, false, false, false, null);
        TWMOrdersExportConfiguration config = new TWMOrdersExportConfiguration();
        config.setStartDate(new Date(System.currentTimeMillis()));
        config.setEndDate(new Date(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.chooseNumbers || source == this.choosePeriod) {
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        CheckedListAdder.addToList(a, this.periodEditor);
        return a;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals(START_DATE)) {
                try {
                    long l = Long.valueOf(v);
                    this.periodEditor.getStartDateChooser().getNode().setValue((Object)new Date(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            if (n.equals(END_DATE)) {
                try {
                    long l = Long.valueOf(v);
                    this.periodEditor.getEndDateChooser().getNode().setValue((Object)new Date(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "includeSummary": {
                    this.includeSummary.getElement().setChecked(b);
                    break;
                }
                case "includeSupplierOverview": {
                    this.includeSupplierOverview.getElement().setChecked(b);
                    break;
                }
                case "includeAllOrders": {
                    this.includeAllOrders.getElement().setChecked(b);
                    break;
                }
                case "includeApprovedOrders": {
                    this.includeApprovedOrders.getElement().setChecked(b);
                    break;
                }
                case "includeNotApprovedOrders": {
                    this.includeNotApprovedOrders.getElement().setChecked(b);
                    break;
                }
                case "includeNotCheckedOrders": {
                    this.includeNotCheckedOrders.getElement().setChecked(b);
                    break;
                }
                case "useOnlyAttachedOrders": {
                    this.useOnlyAttachedOrders.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty(START_DATE, "" + this.periodEditor.getStartDate().getTime());
        conf.addProperty(END_DATE, "" + this.periodEditor.getEndDate().getTime());
        conf.addProperty(INCLUDE_SUMMARY, "" + this.includeSummary.getElement().isChecked());
        conf.addProperty(INCLUDE_SUPPLIER_OVERIVEW, "" + this.includeSupplierOverview.getElement().isChecked());
        conf.addProperty(INCLUDE_ALL_ORDERS, "" + this.includeAllOrders.getElement().isChecked());
        conf.addProperty(INCLUDE_APPROVED_ORDERS, "" + this.includeApprovedOrders.getElement().isChecked());
        conf.addProperty(INCLUDE_NOT_APPROVED_ORDERS, "" + this.includeNotApprovedOrders.getElement().isChecked());
        conf.addProperty(INCLUDE_NOT_CHECKED_ORDERS, "" + this.includeNotCheckedOrders.getElement().isChecked());
        conf.addProperty("useOnlyAttachedOrders", "" + this.useOnlyAttachedOrders.getElement().isChecked());
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.periodEditor = new TitledPeriodEditor((Node<Date>)this.configNode.getChildNamed(new String[]{START_DATE}), (Node<Date>)this.configNode.getChildNamed(new String[]{END_DATE}), true, null, (String)null);
        this.numberChooser = new TitledItem<TextField>(new TextField(), Words.NUMBERS, TitledItem.TitledItemOrientation.NORTH);
        this.numberChooserInfo = new InfoButton();
        this.numberChooserInfo.installStringViewer(Words.TWM_NUMBER_CHOOSER_INFO_TEXT);
        this.sep1 = new HorizontalSeparator();
        this.choosePeriod = new RadioButton();
        this.choosePeriod.setChecked(true);
        this.choosePeriod.addButtonListener(this);
        this.chooseNumbers = new RadioButton();
        this.chooseNumbers.addButtonListener(this);
        this.includeSummary = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_SUMMARY})), Words.INCLUDE_SUMMARY_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeSupplierOverview = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_SUPPLIER_OVERIVEW})), Words.INCLUDE_SUPPLIER_SUMMARY_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeAllOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_ALL_ORDERS})), Words.INCLUDE_ALL_ORDERS_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeApprovedOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_APPROVED_ORDERS})), Words.INCLUDE_APPROVED_ORDERS_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeNotApprovedOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_NOT_APPROVED_ORDERS})), Words.INCLUDE_NOT_APPROVED_ORDERS_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeNotCheckedOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_NOT_CHECKED_ORDERS})), Words.INCLUDE_NOT_CHECKED_ORDERS_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.SUPPLIER);
        this.sortBy.getElement().addItem(Words.DATE);
        this.sortBy.getElement().addItem(Words.NONE);
        this.useOnlyAttachedOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{USE_ONLY_ATTACHED_ORDERS})), Words.USE_ONLY_ATTACHED_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeSummary);
        this.getViewContainer().add(this.includeSupplierOverview);
        this.getViewContainer().add(this.includeAllOrders);
        this.getViewContainer().add(this.includeApprovedOrders);
        this.getViewContainer().add(this.includeNotApprovedOrders);
        this.getViewContainer().add(this.includeNotCheckedOrders);
        this.getViewContainer().add(this.periodEditor);
        this.getViewContainer().add(this.sortBy);
        this.getViewContainer().add(this.numberChooserInfo);
        this.getViewContainer().add(this.numberChooser);
        this.getViewContainer().add(this.choosePeriod);
        this.getViewContainer().add(this.chooseNumbers);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.useOnlyAttachedOrders);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean p = this.choosePeriod.isChecked();
        if (this.periodEditor != null) {
            this.periodEditor.setEnabled(isEnabled && p);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setEnabled(isEnabled && !p);
        }
        boolean b = isEnabled;
        if (this.asXLS != null) {
            boolean bl = b = b && ((RadioButton)this.asXLS.getElement()).isChecked();
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setEnabled(isEnabled);
        }
    }

    @Override
    public String getTitleString() {
        return Words.THREE_WAY_MATCH;
    }

    @Override
    public String getTitleValue() {
        return Words.ANALYSIS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        this.periodEditor = null;
        if (this.includeSummary != null) {
            this.includeSummary.kill();
        }
        this.includeSummary = null;
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.kill();
        }
        this.includeSupplierOverview = null;
        if (this.includeAllOrders != null) {
            this.includeAllOrders.kill();
        }
        this.includeAllOrders = null;
        if (this.includeApprovedOrders != null) {
            this.includeApprovedOrders.kill();
        }
        this.includeApprovedOrders = null;
        if (this.includeNotApprovedOrders != null) {
            this.includeNotApprovedOrders.kill();
        }
        this.includeNotApprovedOrders = null;
        if (this.includeNotCheckedOrders != null) {
            this.includeNotCheckedOrders.kill();
        }
        this.includeNotCheckedOrders = null;
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        this.sortBy = null;
        if (this.numberChooser != null) {
            this.numberChooser.kill();
        }
        this.numberChooser = null;
        if (this.chooseNumbers != null) {
            this.chooseNumbers.kill();
        }
        this.chooseNumbers = null;
        if (this.choosePeriod != null) {
            this.choosePeriod.kill();
        }
        this.choosePeriod = null;
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.kill();
        }
        this.numberChooserInfo = null;
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.sep1 = null;
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.kill();
        }
        this.useOnlyAttachedOrders = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(true);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setVisible(true);
        }
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.setVisible(true);
        }
        if (this.includeAllOrders != null) {
            this.includeAllOrders.setVisible(true);
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setVisible(true);
        }
        if (this.includeApprovedOrders != null) {
            this.includeApprovedOrders.setVisible(true);
        }
        if (this.includeNotApprovedOrders != null) {
            this.includeNotApprovedOrders.setVisible(true);
        }
        if (this.includeNotCheckedOrders != null) {
            this.includeNotCheckedOrders.setVisible(true);
        }
        if (this.sortBy != null) {
            this.sortBy.setVisible(true);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setVisible(true);
        }
        if (this.chooseNumbers != null) {
            this.chooseNumbers.setVisible(true);
        }
        if (this.choosePeriod != null) {
            this.choosePeriod.setVisible(true);
        }
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(false);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setVisible(false);
        }
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.setVisible(false);
        }
        if (this.includeAllOrders != null) {
            this.includeAllOrders.setVisible(false);
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setVisible(false);
        }
        if (this.includeApprovedOrders != null) {
            this.includeApprovedOrders.setVisible(false);
        }
        if (this.includeNotApprovedOrders != null) {
            this.includeNotApprovedOrders.setVisible(false);
        }
        if (this.includeNotCheckedOrders != null) {
            this.includeNotCheckedOrders.setVisible(false);
        }
        if (this.sortBy != null) {
            this.sortBy.setVisible(false);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setVisible(false);
        }
        if (this.chooseNumbers != null) {
            this.chooseNumbers.setVisible(false);
        }
        if (this.choosePeriod != null) {
            this.choosePeriod.setVisible(false);
        }
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.configNode.commit();
                TWMOrdersExportConfiguration config = (TWMOrdersExportConfiguration)ThreeWayMatchPeriodOrderAnalysisComponent.this.configNode.getValue();
                if (!ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.isChecked()) {
                    config.setStartDate(ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getStartDate());
                    config.setEndDate(ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getEndDate());
                } else {
                    config.setStartDate(null);
                    config.setEndDate(null);
                }
                config.setIncludeAllOrders(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.getElement()).isChecked());
                config.setIncludeApprovedOrders(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.getElement()).isChecked());
                config.setIncludeNotApprovedOrders(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.getElement()).isChecked());
                config.setIncludeNotCheckedOrders(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.getElement()).isChecked());
                config.setIncludeSummary(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.getElement()).isChecked());
                config.setIncludeSupplierOverview(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.getElement()).isChecked());
                config.setTwmNumbers(ThreeWayMatchPeriodOrderAnalysisComponent.this.getTWMNumbers());
                config.setUseNumbers(ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.isChecked());
                config.setShowOnlyAttachedOrders(((CheckBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.getElement()).isChecked());
                if (((ComboBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.SUPPLIER)) {
                    config.setSortBySupplier(true);
                } else if (((ComboBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.DATE)) {
                    config.setSortByDate(true);
                } else if (((ComboBox)ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.NONE)) {
                    config.setSortByNone(true);
                }
                PegasusFileComplete t = (PegasusFileComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).createOrderExport(config).getValue();
                ThreeWayMatchPeriodOrderAnalysisComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ThreeWayMatchPeriodOrderAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    private List<Integer> getTWMNumbers() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (this.chooseNumbers.isChecked()) {
            String[] s;
            String t = this.numberChooser.getElement().getText();
            for (String ss : s = t.split(",")) {
                try {
                    int i = Integer.valueOf(ss);
                    l.add(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    @Override
    public Node<ThreeWayMatchLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<ThreeWayMatchLight> createBatchJob(Node<ThreeWayMatchLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ThreeWayMatchPeriodOrderAnalysisComponent.this.layoutInheritedComponents(parent);
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.setLocation((int)((double)ThreeWayMatchPeriodOrderAnalysisComponent.this.border + ThreeWayMatchPeriodOrderAnalysisComponent.this.choosePeriod.getPreferredSize().getWidth() + 3.0), y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 2);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.setSize((int)((double)parent.getWidth() - ((double)(2 * ThreeWayMatchPeriodOrderAnalysisComponent.this.border) + ThreeWayMatchPeriodOrderAnalysisComponent.this.choosePeriod.getPreferredSize().getWidth() + 3.0)), (int)ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getPreferredSize().getHeight());
                ThreeWayMatchPeriodOrderAnalysisComponent.this.choosePeriod.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + 31);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.choosePeriod.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.choosePeriod.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.setLocation((int)((double)ThreeWayMatchPeriodOrderAnalysisComponent.this.border + ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.getPreferredSize().getWidth() + 3.0), y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.setSize((int)((double)parent.getWidth() - ((double)(2 * ThreeWayMatchPeriodOrderAnalysisComponent.this.border) + ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.getPreferredSize().getWidth() + 3.0 + 3.0 + ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooserInfo.getPreferredSize().getWidth())), (int)ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getPreferredSize().getHeight());
                ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + 27);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.chooseNumbers.getPreferredSize());
                ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooserInfo.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getX() + ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getWidth() + 3, ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getY() + 24);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooserInfo.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooserInfo.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1 != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.setLocation(0, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.setSize(parent.getWidth(), (int)ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.getPreferredSize().getHeight());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.setSize(ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.getPreferredSize());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.getHeight();
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy != null) {
                ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.setLocation(ThreeWayMatchPeriodOrderAnalysisComponent.this.border, y + ThreeWayMatchPeriodOrderAnalysisComponent.this.border);
                ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.setSize(200, (int)ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getPreferredSize().getHeight());
                y = ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getY() + ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ThreeWayMatchPeriodOrderAnalysisComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.periodEditor.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.numberChooser.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1 != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.sep1.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSummary.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeAllOrders.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.useOnlyAttachedOrders.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeApprovedOrders.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotApprovedOrders.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            }
            if (ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy != null) {
                h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border;
                h = (int)((double)h + ThreeWayMatchPeriodOrderAnalysisComponent.this.sortBy.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += ThreeWayMatchPeriodOrderAnalysisComponent.this.border);
        }
    }
}

