/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.util;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class DefaultServerSideAnalysisComponent<T extends ADTO, V extends ADTO>
extends AnalysisPopupInsert<T> {
    private static final long serialVersionUID = 1L;

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis) {
        this(defaultAnalysis, false, false);
    }

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis, boolean isExportFormatChoosable) {
        super(defaultAnalysis, isExportFormatChoosable);
    }

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis, boolean isExportFormatChoosable, boolean withNumbers) {
        super(defaultAnalysis, isExportFormatChoosable, withNumbers, null, true);
    }

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis, boolean isExportFormatChoosable, boolean withNumbers, boolean isDataToExportChoosable) {
        super(defaultAnalysis, isExportFormatChoosable, withNumbers, null, isDataToExportChoosable);
    }

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis, boolean isExportFormatChoosable, ReportTypeE reportType) {
        super(defaultAnalysis, isExportFormatChoosable, reportType);
    }

    public DefaultServerSideAnalysisComponent(AnalysisSmartExternalOpenTool<T> defaultAnalysis, boolean isExportFormatChoosable, boolean withNumbers, ReportTypeE reportType) {
        super(defaultAnalysis, isExportFormatChoosable, withNumbers, reportType);
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    protected String getProgressText() {
        return WordsToolkit.toCapitalLetter((String)Words.CREATE_REPORT);
    }

    @Override
    public String getTitleValue() {
        return Words.ALL;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    public List<V> loadItemReferences() throws ServiceException {
        ArrayList<V> references = new ArrayList<V>();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            V i = this.createReference((ADTO)s.next());
            if (i == null) continue;
            references.add(i);
        }
        return references;
    }

    public abstract V createReference(T var1);

    public abstract PegasusFileComplete createReport() throws Exception;

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                DefaultServerSideAnalysisComponent.this.writeConfigurationValues();
                PegasusFileComplete file = DefaultServerSideAnalysisComponent.this.createReport();
                if (file != null) {
                    if (file.getLocalFile() == null) {
                        File f = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                            public void statusChanged(File file, FileTransferState state) {
                            }

                            public void exceptionOccurred(Exception exception) {
                                InnerPopupFactory.showErrorDialog(exception, (Component)DefaultServerSideAnalysisComponent.this);
                            }
                        }});
                        FileUtils.copyFile((File)f, (File)DefaultServerSideAnalysisComponent.this.getSelectedFile());
                    }
                    if (DefaultServerSideAnalysisComponent.this.popup.isPreview()) {
                        try {
                            PrintPopupToolkit.previewFile(DefaultServerSideAnalysisComponent.this.getSelectedFile());
                        }
                        catch (Exception e) {
                            InnerPopupFactory.showErrorDialog(e, (Component)DefaultServerSideAnalysisComponent.this);
                        }
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return DefaultServerSideAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

