/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.invoice;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.client.util.DownloadState;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.invoice.HistoricalInvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportInvoiceComponent
extends DefaultScrollablePrintPopupInsert
implements FileTransferListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    static Logger log = LoggerFactory.getLogger(ExportInvoiceComponent.class);
    private boolean isOverride = false;
    private Node<InvoiceLight> currentNode;
    private TitledItem<ComboBox> exportType;
    private TitledItem<RadioButtonBox> box;
    private TitledItem<RadioButton> sortByMealPlan;
    private TitledItem<RadioButton> sortByNumber;
    private TitledItem<RadioButton> sortByName;
    private TitledItem<CheckBox> includeNullValues;
    private TitledItem<CheckBox> showProductsInsteadOfFixPrice;
    private TitledItem<CheckBox> includePax;
    private TitledItem<CheckBox> showCompleteConversion;
    private DownloadState downloaded;
    private boolean invoiceClosedMode = false;
    private RowModel currentModel;
    private boolean isNoPro = false;

    public ExportInvoiceComponent(Node<InvoiceLight> currentNode, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.currentNode = currentNode;
        this.initInvoiceClosedMode();
        this.getViewContainer().setLayout(new Layout());
        if (this.invoiceClosedMode) {
            this.createComponents();
        } else if (currentNode.getValue(InvoiceComplete.class) != null) {
            this.createComponents();
        } else {
            this.ensureAnimation(Words.LOAD_DATA);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    InvoiceLight l = (InvoiceLight)ExportInvoiceComponent.this.currentNode.getValue(InvoiceLight.class);
                    InvoiceComplete c = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice((InvoiceReference)l).getValue();
                    ExportInvoiceComponent.this.currentNode.setValue((Object)c, 0L);
                    return ExportInvoiceComponent.this.currentNode;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ExportInvoiceComponent.this.removeAnimation(false);
                            ExportInvoiceComponent.this.currentNode = node;
                            ExportInvoiceComponent.this.createComponents();
                        }

                        public void errorOccurred(ClientException exception) {
                            ExportInvoiceComponent.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private void initInvoiceClosedMode() {
        HistoricalInvoiceComplete historic;
        this.invoiceClosedMode = ((InvoiceLight)this.currentNode.getValue()).getState() == InvoiceStateE.CLOSED || ((InvoiceLight)this.currentNode.getValue()).getState() == InvoiceStateE.CREDIT_NOTE || ((InvoiceLight)this.currentNode.getValue()).getState() == InvoiceStateE.CANCELLED ? (historic = ((InvoiceLight)this.currentNode.getValue()).getFinalData()) != null && !Boolean.TRUE.equals(((InvoiceLight)this.currentNode.getValue()).getHasError()) : false;
    }

    private void hideCheckBoxes(boolean includeFixPrice) {
        if (this.showProductsInsteadOfFixPrice != null && includeFixPrice) {
            this.showProductsInsteadOfFixPrice.fadeOut(false);
        }
        if (this.box != null) {
            this.box.fadeOut(false);
        }
        if (this.includeNullValues != null && includeFixPrice) {
            this.includeNullValues.fadeOut(false);
        }
        if (this.includePax != null) {
            this.includePax.fadeOut(false);
        }
        if (this.showCompleteConversion != null) {
            this.showCompleteConversion.fadeOut(false);
        }
    }

    private void showCheckBoxes() {
        if (this.showProductsInsteadOfFixPrice == null) {
            this.showProductsInsteadOfFixPrice = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCTS_INSTEAD_OF_FIX_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.showProductsInsteadOfFixPrice.getFader().setPermanent(true);
            this.getViewContainer().add(this.showProductsInsteadOfFixPrice);
        }
        if (!this.showProductsInsteadOfFixPrice.getFader().isFaded()) {
            this.showProductsInsteadOfFixPrice.fadeIn();
        }
        if (this.box == null) {
            this.box = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Sort by", TitledItem.TitledItemOrientation.NORTH);
            this.box.getFader().setPermanent(true);
            this.box.getElement().setBorder(0);
            this.getViewContainer().add(this.box);
        }
        if (this.sortByMealPlan == null) {
            this.sortByMealPlan = new TitledItem<RadioButton>(new RadioButton(), Words.MEALPLAN, TitledItem.TitledItemOrientation.EAST);
            this.sortByMealPlan.getFader().setPermanent(true);
            this.box.getElement().addBox(this.sortByMealPlan, this.sortByMealPlan.getElement());
        }
        if (this.sortByNumber == null) {
            this.sortByNumber = new TitledItem<RadioButton>(new RadioButton(), WordsToolkit.toCapitalLetter((String)Words.NUMBER), TitledItem.TitledItemOrientation.EAST);
            this.sortByNumber.getFader().setPermanent(true);
            this.box.getElement().addBox(this.sortByNumber, this.sortByNumber.getElement());
        }
        if (this.sortByName == null) {
            this.sortByName = new TitledItem<RadioButton>(new RadioButton(), WordsToolkit.toCapitalLetter((String)Words.NAME), TitledItem.TitledItemOrientation.EAST);
            this.sortByName.getFader().setPermanent(true);
            this.box.getElement().addBox(this.sortByName, this.sortByName.getElement());
        }
        if (this.includeNullValues == null) {
            this.includeNullValues = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ZERO_PRICE_ITEMS, TitledItem.TitledItemOrientation.EAST);
            this.includeNullValues.getFader().setPermanent(true);
            this.getViewContainer().add(this.includeNullValues);
        }
        this.sortByMealPlan.getElement().setChecked(true);
        if (this.includePax == null) {
            this.includePax = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PAX_COUNT, TitledItem.TitledItemOrientation.EAST);
            this.includePax.getElement().setChecked(true);
            this.includePax.getFader().setPermanent(true);
            this.getViewContainer().add(this.includePax);
        }
        if (this.showCompleteConversion == null) {
            this.showCompleteConversion = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_COMPLETE_CONVERSION, TitledItem.TitledItemOrientation.EAST);
            this.showCompleteConversion.getFader().setPermanent(true);
            this.showCompleteConversion.getElement().setChecked(true);
            this.getViewContainer().add(this.showCompleteConversion);
        }
        this.box.fadeIn();
        this.includeNullValues.fadeIn();
        this.includePax.fadeIn();
        this.showCompleteConversion.fadeIn();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    public void downloadFile(PegasusFileComplete fileReference) throws Exception {
        FileTransferUtil.download((PegasusFileComplete)fileReference, (FileTransferListener[])new FileTransferListener[]{this});
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.exportType = new TitledItem<ComboBox>(new ComboBox(), "Export Type", TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.exportType);
        this.exportType.getElement().addItem(ExportType.DETAILED_EXCEL_EXPORT);
        this.exportType.getElement().addItem(ExportType.EXCEL_EXPORT);
        this.exportType.getElement().addItem(ExportType.FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT);
        this.exportType.getElement().addItemListener(this);
        if (!this.invoiceClosedMode && !this.isNoPro) {
            this.showCheckBoxes();
        }
    }

    @Override
    public String getTitleString() {
        return "INVOICE NO";
    }

    @Override
    public String getTitleValue() {
        String t = "???";
        if (this.currentNode.getChildNamed(new String[]{"number"}).getValue() != null) {
            t = "" + this.currentNode.getChildNamed(new String[]{"number"}).getValue();
        }
        return t;
    }

    @Override
    protected String getProgressText() {
        return "Export Invoice";
    }

    @Override
    protected String getFinishedText() {
        return "Export finished";
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        CheckedListAdder.addToList(a, this.exportType);
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[5];
        if (this.printer != null) {
            o[0] = ((ComboBox)this.printer.getElement()).getSelectedItem();
        }
        if (this.copies != null) {
            o[1] = ((TextField)this.copies.getElement()).getText();
        }
        if (this.exportType != null) {
            o[2] = this.exportType.getElement().getSelectedItem();
        }
        o[3] = this.currentNode;
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.exportType != null && this.exportType.getElement().isInnerComponent(c)) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.hideCheckBoxes(true);
        if (this.exportType != null) {
            this.exportType.kill();
        }
        this.exportType = null;
        this.currentModel.getView().revalidate();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.exportType != null) {
            this.exportType.setVisible(false);
        }
        this.hideCheckBoxes(true);
    }

    private String createNothingFoundString() {
        String t = "<b>Nothing to Export</b><br/>";
        t = t + "Please checked any Flights/TradegGoods/Customs are added.";
        return t;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PegasusFileComplete t = null;
                if (ExportInvoiceComponent.this.invoiceClosedMode) {
                    InvoiceLight ic = (InvoiceLight)ExportInvoiceComponent.this.currentNode.getValue();
                    HistoricalInvoiceComplete historic = ic.getFinalData();
                    if (historic == null) {
                        throw new Exception("No Historic Data found");
                    }
                    if (ic.getState() == InvoiceStateE.CREDIT_NOTE) {
                        t = historic.getReport();
                    } else if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.DETAILED_EXCEL_EXPORT) {
                        t = historic.getDetailedExport();
                    } else if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.EXCEL_EXPORT) {
                        t = historic.getExcelExport();
                    } else if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT) {
                        t = historic.getOverviewExport();
                    }
                    ExportInvoiceComponent.this.downloadFile(t);
                } else {
                    InvoiceComplete l = (InvoiceComplete)ExportInvoiceComponent.this.currentNode.getValue(InvoiceComplete.class);
                    if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.DETAILED_EXCEL_EXPORT) {
                        boolean isF = false;
                        boolean isS = false;
                        boolean sortByMealPlan = true;
                        boolean sortByName = false;
                        boolean sortByNumber = false;
                        boolean include0Values = false;
                        boolean showCompleteConversionB = false;
                        boolean includePaxCount = ((CheckBox)ExportInvoiceComponent.this.includePax.getElement()).isChecked();
                        if (ExportInvoiceComponent.this.sortByMealPlan != null) {
                            sortByMealPlan = ((RadioButton)ExportInvoiceComponent.this.sortByMealPlan.getElement()).isChecked();
                        }
                        if (ExportInvoiceComponent.this.sortByName != null) {
                            sortByName = ((RadioButton)ExportInvoiceComponent.this.sortByName.getElement()).isChecked();
                        }
                        if (ExportInvoiceComponent.this.sortByNumber != null) {
                            sortByNumber = ((RadioButton)ExportInvoiceComponent.this.sortByNumber.getElement()).isChecked();
                        }
                        if (ExportInvoiceComponent.this.includeNullValues != null) {
                            include0Values = ((CheckBox)ExportInvoiceComponent.this.includeNullValues.getElement()).isChecked();
                        }
                        if (ExportInvoiceComponent.this.showProductsInsteadOfFixPrice != null) {
                            isS = ((CheckBox)ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getElement()).isChecked();
                        }
                        if (ExportInvoiceComponent.this.showCompleteConversion != null) {
                            showCompleteConversionB = ((CheckBox)ExportInvoiceComponent.this.showCompleteConversion.getElement()).isChecked();
                        }
                        PegasusFileComplete f = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createInvoiceExport((InvoiceReference)l, isF, isS, sortByMealPlan, sortByName, sortByNumber, include0Values, includePaxCount, new ListWrapper(new ArrayList()), showCompleteConversionB).getValue();
                        FileTransferUtil.download((PegasusFileComplete)f, (FileTransferListener[])new FileTransferListener[]{ExportInvoiceComponent.this});
                    } else if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.EXCEL_EXPORT) {
                        boolean useProductsInsteadOfFixMeals = ((CheckBox)ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getElement()).isChecked();
                        boolean includeZeroPriceItems = ((CheckBox)ExportInvoiceComponent.this.includeNullValues.getElement()).isChecked();
                        t = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createInvoiceExcelExport(new InvoiceReference(l.getId()), useProductsInsteadOfFixMeals, includeZeroPriceItems).getValue();
                        ExportInvoiceComponent.this.downloadFile(t);
                    } else if (((ComboBox)ExportInvoiceComponent.this.exportType.getElement()).getSelectedItem() == ExportType.FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT) {
                        boolean useProductsInsteadOfFixMeals = ((CheckBox)ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getElement()).isChecked();
                        boolean includeZeroPriceItems = ((CheckBox)ExportInvoiceComponent.this.includeNullValues.getElement()).isChecked();
                        t = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createFlightInvoiceOverviewExport(new InvoiceReference(l.getId()), includeZeroPriceItems).getValue();
                        ExportInvoiceComponent.this.downloadFile(t);
                    }
                }
                ExportInvoiceComponent.this.currentModel.getView().revalidate();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportInvoiceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation(false);
        if (this.downloaded == DownloadState.DOWNLOADED) {
            if (this.errorMSG != null) {
                this.showMessage(this.errorMSG);
                this.popup.setOkButtonText("CLOSE");
                this.popup.hideCancelButton();
            } else {
                super.remoteObjectLoaded(node);
            }
        } else if (this.downloaded != DownloadState.NOT_SAVED) {
            this.showMessage("Exported");
        }
        this.popup.enableCancelButton(true);
    }

    public void statusChanged(File file, FileTransferState state) {
        if (state.getState() == FileTransferState.State.FINISHED) {
            this.downloaded = DownloadState.DOWNLOADED;
            this.showSaveDialog(file);
        } else if (state.getState() != FileTransferState.State.NEW) {
            double d = (double)state.getTransferred() / (double)state.getSize();
            int i = (int)(d *= 100.0);
            this.animation.stateChanged("Download " + i + "%");
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.isOverride) {
            super.enterPressed(isOK);
        } else {
            this.isOverride = false;
            this.popup.setCancelButtonText("Cancel");
            this.popup.enableCancelButton(false);
            this.downloaded = null;
            this.remoteObjectLoaded(this.currentNode);
        }
    }

    private void showSaveDialog(File file) {
        MainFrame.isTempRelease = true;
        File fileName = null;
        if (this.exportType.getElement().getSelectedItem() == ExportType.DETAILED_EXCEL_EXPORT) {
            fileName = FileChooserUtil.saveFile(".zip");
        } else if (this.exportType.getElement().getSelectedItem() == ExportType.EXCEL_EXPORT) {
            fileName = FileChooserUtil.saveFile(".xlsx");
        } else if (this.exportType.getElement().getSelectedItem() == ExportType.FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT) {
            fileName = FileChooserUtil.saveFile(".xlsx");
        }
        if (fileName != null) {
            File selectedFile = fileName;
            if (selectedFile.exists()) {
                this.isOverride = true;
                this.downloaded = DownloadState.NOT_SAVED;
                this.errorMSG = "File already exists. Do you want to override it?";
                this.removeInheritedComponents();
                this.processReturnValue(this.errorMSG);
                this.showMessage(this.errorMSG);
            } else {
                this.moveFile(file, selectedFile);
            }
        } else {
            this.downloaded = DownloadState.NOT_SAVED;
            this.removeInheritedComponents();
            this.popup.enableCancelButton(false);
            this.showMessage("<b>Operation canceled!</b>");
        }
        MainFrame.isTempRelease = false;
    }

    private void processReturnValue(String t) {
        if (t != null && t.isEmpty()) {
            t = null;
        }
        if (t == null) {
            this.isError = false;
            this.errorMSG = null;
        } else {
            this.isError = true;
            this.errorMSG = t;
        }
    }

    private void moveFile(File source, File destination) {
        try {
            if (!source.renameTo(destination)) {
                this.errorMSG = "Unable to save file";
            } else {
                this.showMessage("Exported");
            }
        }
        catch (Exception e) {
            this.errorMSG = e.getMessage();
        }
        this.isOverride = false;
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getItem() == ExportType.DETAILED_EXCEL_EXPORT) {
                super.showInheritedComponents();
                if (!this.invoiceClosedMode) {
                    this.showCheckBoxes();
                } else {
                    this.hideCheckBoxes(true);
                }
            } else if (e.getItem() == ExportType.EXCEL_EXPORT) {
                this.hideCheckBoxes(true);
            } else if (e.getItem() == ExportType.FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT) {
                this.hideCheckBoxes(true);
            }
            this.getViewContainer().invalidate();
            this.getViewContainer().validate();
            this.getViewContainer().repaint(32L);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportInvoiceComponent.this.layoutInheritedComponents(parent);
            if (ExportInvoiceComponent.this.exportType != null) {
                ExportInvoiceComponent.this.exportType.setLocation(ExportInvoiceComponent.this.border, y + ExportInvoiceComponent.this.border);
                ExportInvoiceComponent.this.exportType.setSize(parent.getWidth() - 2 * ExportInvoiceComponent.this.border, (int)ExportInvoiceComponent.this.exportType.getPreferredSize().getHeight());
                if (ExportInvoiceComponent.this.showProductsInsteadOfFixPrice != null && ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getElement() != null) {
                    ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.setLocation(ExportInvoiceComponent.this.border, ExportInvoiceComponent.this.exportType.getY() + ExportInvoiceComponent.this.exportType.getHeight() + ExportInvoiceComponent.this.border);
                    ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.setSize(ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getPreferredSize());
                    ExportInvoiceComponent.this.includeNullValues.setLocation(ExportInvoiceComponent.this.border, ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getY() + ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getHeight() + ExportInvoiceComponent.this.border / 2);
                    ExportInvoiceComponent.this.includeNullValues.setSize(ExportInvoiceComponent.this.includeNullValues.getPreferredSize());
                    ExportInvoiceComponent.this.includePax.setLocation(ExportInvoiceComponent.this.border, ExportInvoiceComponent.this.includeNullValues.getY() + ExportInvoiceComponent.this.includeNullValues.getHeight() + ExportInvoiceComponent.this.border);
                    ExportInvoiceComponent.this.includePax.setSize(ExportInvoiceComponent.this.includePax.getPreferredSize());
                    ExportInvoiceComponent.this.showCompleteConversion.setLocation(ExportInvoiceComponent.this.border, ExportInvoiceComponent.this.includePax.getY() + ExportInvoiceComponent.this.includePax.getHeight() + ExportInvoiceComponent.this.border);
                    ExportInvoiceComponent.this.showCompleteConversion.setSize(ExportInvoiceComponent.this.showCompleteConversion.getPreferredSize());
                    if (ExportInvoiceComponent.this.box != null) {
                        ExportInvoiceComponent.this.box.setLocation(ExportInvoiceComponent.this.border, ExportInvoiceComponent.this.showCompleteConversion.getY() + ExportInvoiceComponent.this.showCompleteConversion.getHeight() + ExportInvoiceComponent.this.border);
                        ExportInvoiceComponent.this.box.setSize(ExportInvoiceComponent.this.box.getPreferredSize());
                    }
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportInvoiceComponent.this.getInheritedComponentsHeight();
            h += ExportInvoiceComponent.this.border;
            if (ExportInvoiceComponent.this.exportType != null) {
                h = (int)((double)h + ExportInvoiceComponent.this.exportType.getPreferredSize().getHeight());
                h += ExportInvoiceComponent.this.border;
                if (ExportInvoiceComponent.this.showProductsInsteadOfFixPrice != null && ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getElement() != null) {
                    h = (int)((double)h + ExportInvoiceComponent.this.showProductsInsteadOfFixPrice.getPreferredSize().getHeight());
                    h += ExportInvoiceComponent.this.border;
                    h = (int)((double)h + ExportInvoiceComponent.this.box.getPreferredSize().getHeight());
                    h += ExportInvoiceComponent.this.border;
                    h = (int)((double)h + ExportInvoiceComponent.this.includeNullValues.getPreferredSize().getHeight());
                    h += ExportInvoiceComponent.this.border;
                    h = (int)((double)h + ExportInvoiceComponent.this.includePax.getPreferredSize().getHeight());
                    h += ExportInvoiceComponent.this.border;
                    h = (int)((double)h + ExportInvoiceComponent.this.showCompleteConversion.getPreferredSize().getHeight());
                    h += ExportInvoiceComponent.this.border;
                }
            } else {
                h += 200;
            }
            return new Dimension(0, h);
        }
    }

    public static enum ExportType {
        DETAILED_EXCEL_EXPORT,
        EXCEL_EXPORT,
        FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT;


        public String toString() {
            switch (this) {
                case DETAILED_EXCEL_EXPORT: {
                    return "Detailed Excel Report (new)";
                }
                case EXCEL_EXPORT: {
                    return "Excel Report (Flights only)";
                }
                case FLIGHT_INVOICE_OVERVIEW_EXCEL_EXPORT: {
                    return "Flight Invoice Overview";
                }
            }
            return "";
        }
    }
}

