/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.knife;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.tracking.KnifeTrackingServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;

public class ExportKnifeUsageComponent
extends DefaultScrollablePrintPopup2<KnifeComplete> {
    private static final long serialVersionUID = 1L;
    private Node<KnifeComplete> knife;
    private TitledPeriodEditor periodEditor;

    public ExportKnifeUsageComponent(Node<KnifeComplete> dto) {
        super(false, false, false, false, null);
        this.knife = dto;
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), false, false);
        this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)periodNode, null);
        this.getViewContainer().add(this.periodEditor);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public String getTitleString() {
        return Words.KNIFE;
    }

    @Override
    public String getTitleValue() {
        return ((KnifeComplete)this.knife.getValue()).getBarcode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<KnifeReference> knifes = new ArrayList<KnifeReference>();
                knifes.add(new KnifeReference(((KnifeComplete)ExportKnifeUsageComponent.this.knife.getValue()).getId()));
                PeriodComplete period = ExportKnifeUsageComponent.this.periodEditor.getPeriod();
                PegasusFileComplete t = (PegasusFileComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).createKnifeTrackingReport(new ListWrapper(knifes), period).getValue();
                ExportKnifeUsageComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportKnifeUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<KnifeComplete> getCurrentNode() {
        return this.knife;
    }

    @Override
    public BatchJob<KnifeComplete> createBatchJob(Node<KnifeComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportKnifeUsageComponent.this.layoutInheritedComponents(parent) + ExportKnifeUsageComponent.this.border;
            ExportKnifeUsageComponent.this.periodEditor.setLocation(ExportKnifeUsageComponent.this.border, y);
            ExportKnifeUsageComponent.this.periodEditor.setSize(ExportKnifeUsageComponent.this.periodEditor.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportKnifeUsageComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

