/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.mealplan.factsheets;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MealPlanAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ExportMealPlanProductFactSheetComponent
extends DefaultScrollablePrintPopup2<MealPlanLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<MealPlanLight> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep1;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeManMinutes;
    private TitledItem<CheckBox> includeProductMM;
    private TitledItem<CheckBox> includeGroupMM;
    private TitledItem<CheckBox> includeComponentMM;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> includeMealPlanAndStowingListData;
    private TitledItem<ComboBox> includeTender;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<CheckBox> splitCostCenters;
    private boolean showProductionCosts = false;
    private boolean printExternalCostFactSheet = false;

    public ExportMealPlanProductFactSheetComponent(Node<MealPlanLight> node) {
        super(false, false, false, null);
        this.currentProduct = node;
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(MealPlanAccess.MODULE_MEAL_PLAN, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals(MealPlanAccess.SHOW_PRODUCTION_COSTS.getName())) {
                    this.showProductionCosts = true;
                    continue;
                }
                if (!a.getField().getName().equals(MealPlanAccess.PRINT_EXTERNAL_COST_FACT_SHEET.getName())) continue;
                this.printExternalCostFactSheet = true;
            }
        };
        this.loadBeforeShowing(r);
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setDueDate(new Timestamp(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node dNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.sep1 = new HorizontalSeparator();
        this.printOptionTitle = new TextLabel(WordsToolkit.toUpperCase((String)Words.OPTIONS));
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS_SALES_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.includeCosts.setTitleFont(f);
        this.includeCosts.setTitleForeground(fb);
        this.includeCosts.getElement().setChecked(this.showProductionCosts);
        this.includeCosts.getElement().addButtonListener(this);
        this.includeTender = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
        this.includeTender.getElement().addItem(Words.ALL);
        this.includeTender.getElement().addItem(Words.TENDER);
        this.includeTender.getElement().addItem(Words.PRODUCTIVE);
        if (!this.printExternalCostFactSheet) {
            this.includeTender.getElement().setSelectedItem(Words.PRODUCTIVE);
        }
        this.includeMealPlanAndStowingListData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN_AND_STOWING_LIST, TitledItem.TitledItemOrientation.EAST);
        this.includeManMinutes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAN_MINUTES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeProductMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeGroupMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROUP_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeComponentMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_RECIPES_TO_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.splitCostCenters = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.includeCosts);
        this.getViewContainer().add(this.includeTender);
        this.getViewContainer().add(this.includeMealPlanAndStowingListData);
        this.getViewContainer().add(this.includeManMinutes);
        this.getViewContainer().add(this.includeProductMM);
        this.getViewContainer().add(this.includeGroupMM);
        this.getViewContainer().add(this.includeComponentMM);
        this.getViewContainer().add(this.resolveRecipesToArticles);
        this.getViewContainer().add(this.splitCostCenters);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
        this.includeTender.setEnabled(isEnabled && this.printExternalCostFactSheet);
        this.includeMealPlanAndStowingListData.setEnabled(isEnabled);
        this.resolveRecipesToArticles.setEnabled(isEnabled);
        this.includeManMinutes.setEnabled(isEnabled);
        this.includeProductMM.setEnabled(isEnabled);
        this.includeGroupMM.setEnabled(isEnabled);
        this.includeComponentMM.setEnabled(isEnabled);
        this.splitCostCenters.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("costs")) {
                this.includeCosts.getElement().setChecked(b);
            }
            if (n.equals("mp_stowing")) {
                this.includeMealPlanAndStowingListData.getElement().setChecked(b);
            }
            if (n.equals("resolveRecipesToArticles")) {
                this.resolveRecipesToArticles.getElement().setChecked(b);
            }
            if (n.equals("splitCostCenters")) {
                this.splitCostCenters.getElement().setChecked(b);
            }
            if (n.equals("manMinutes")) {
                this.includeManMinutes.getElement().setChecked(b);
            }
            if (n.equals("includeProductMM")) {
                this.includeProductMM.getElement().setChecked(b);
            }
            if (n.equals("includeGroupMM")) {
                this.includeGroupMM.getElement().setChecked(b);
            }
            if (!n.equals("includeComponentMM")) continue;
            this.includeComponentMM.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        conf.addProperty("mp_stowing", "" + this.includeMealPlanAndStowingListData.getElement().isChecked());
        conf.addProperty("resolveRecipesToArticles", "" + this.resolveRecipesToArticles.getElement().isChecked());
        conf.addProperty("splitCostCenters", "" + this.splitCostCenters.getElement().isChecked());
        conf.addProperty("manMinutes", "" + this.includeManMinutes.getElement().isChecked());
        conf.addProperty("includeProductMM", "" + this.includeProductMM.getElement().isChecked());
        conf.addProperty("includeGroupMM", "" + this.includeGroupMM.getElement().isChecked());
        conf.addProperty("includeComponentMM", "" + this.includeComponentMM.getElement().isChecked());
        return conf;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_FACT_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(MealPlanLight_.name).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        if (this.includeTender != null) {
            this.includeTender.kill();
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.kill();
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.kill();
        }
        if (this.includeManMinutes != null) {
            this.includeManMinutes.kill();
        }
        if (this.includeProductMM != null) {
            this.includeProductMM.kill();
        }
        if (this.includeGroupMM != null) {
            this.includeGroupMM.kill();
        }
        if (this.includeComponentMM != null) {
            this.includeComponentMM.kill();
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.kill();
        }
        this.includeMealPlanAndStowingListData = null;
        this.includeTender = null;
        this.printOptionTitle = null;
        this.dueDate = null;
        this.sep1 = null;
        this.includeCosts = null;
        this.resolveRecipesToArticles = null;
        this.splitCostCenters = null;
        this.includeManMinutes = null;
        this.includeProductMM = null;
        this.includeGroupMM = null;
        this.includeComponentMM = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(true);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(true);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(true);
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(false);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(false);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportMealPlanProductFactSheetComponent.this.configNode.commit();
                Date date = null;
                date = ((DateChooser)ExportMealPlanProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() instanceof Date ? (Date)((DateChooser)ExportMealPlanProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() : (((DateChooser)ExportMealPlanProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() instanceof Timestamp ? new Date(((Timestamp)((DateChooser)ExportMealPlanProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue()).getTime()) : new Date(System.currentTimeMillis()));
                ArrayList<Object> catalogs = new ArrayList<Object>();
                catalogs.add(ExportMealPlanProductFactSheetComponent.this.currentProduct.getValue());
                boolean showCosts = false;
                if (ExportMealPlanProductFactSheetComponent.this.showProductionCosts) {
                    showCosts = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeCosts.getElement()).isChecked();
                }
                boolean includeMP_STW = false;
                if (ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                    includeMP_STW = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.getElement()).isChecked();
                }
                boolean manMinutes = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeManMinutes.getElement()).isChecked();
                boolean includeProductMMSheet = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeProductMM.getElement()).isChecked();
                boolean includeGroupMMSheet = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeGroupMM.getElement()).isChecked();
                boolean includeComponentMMSheet = ((CheckBox)ExportMealPlanProductFactSheetComponent.this.includeComponentMM.getElement()).isChecked();
                Boolean showTender = false;
                if (!ExportMealPlanProductFactSheetComponent.this.printExternalCostFactSheet) {
                    showTender = false;
                } else if (((ComboBox)ExportMealPlanProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.ALL)) {
                    showTender = null;
                } else if (((ComboBox)ExportMealPlanProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.TENDER)) {
                    showTender = true;
                } else if (((ComboBox)ExportMealPlanProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.PRODUCTIVE)) {
                    showTender = false;
                }
                boolean resolveRecipes = ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles != null ? ((CheckBox)ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.getElement()).isChecked() : false;
                boolean splitDepartments = ExportMealPlanProductFactSheetComponent.this.splitCostCenters != null ? ((CheckBox)ExportMealPlanProductFactSheetComponent.this.splitCostCenters.getElement()).isChecked() : false;
                ProductFactSheetsReportConfiguration configuration = new ProductFactSheetsReportConfiguration();
                configuration.setDueDate(date);
                configuration.setIncludeCosts(Boolean.valueOf(showCosts));
                configuration.setIncludeMpAndStwUsage(Boolean.valueOf(includeMP_STW));
                configuration.setResolveRecipesToArticles(Boolean.valueOf(resolveRecipes));
                configuration.setIncludeMMSheet(Boolean.valueOf(manMinutes));
                configuration.setShowProductComponentDepartmentsSeperately(Boolean.valueOf(splitDepartments));
                configuration.setIncludeProductMMSheet(Boolean.valueOf(includeProductMMSheet));
                configuration.setIncludeGroupMMSheet(Boolean.valueOf(includeGroupMMSheet));
                configuration.setIncludeComponentMMSheet(Boolean.valueOf(includeComponentMMSheet));
                configuration.setShowTender(showTender);
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductFactSheetExportForMealPlan(new ListWrapper(catalogs), configuration).getValue();
                ExportMealPlanProductFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportMealPlanProductFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<MealPlanLight> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<MealPlanLight> createBatchJob(Node<MealPlanLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportMealPlanProductFactSheetComponent.this.layoutInheritedComponents(parent);
            if (ExportMealPlanProductFactSheetComponent.this.dueDate != null) {
                ExportMealPlanProductFactSheetComponent.this.dueDate.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.dueDate.getY() + ExportMealPlanProductFactSheetComponent.this.dueDate.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.sep1 != null) {
                ExportMealPlanProductFactSheetComponent.this.sep1.setLocation(0, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.sep1.setSize(parent.getWidth(), (int)ExportMealPlanProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.sep1.getY() + ExportMealPlanProductFactSheetComponent.this.sep1.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.printOptionTitle != null) {
                ExportMealPlanProductFactSheetComponent.this.printOptionTitle.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border);
                ExportMealPlanProductFactSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.printOptionTitle.getY() + ExportMealPlanProductFactSheetComponent.this.printOptionTitle.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeCosts != null) {
                ExportMealPlanProductFactSheetComponent.this.includeCosts.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeCosts.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeCosts.getY() + ExportMealPlanProductFactSheetComponent.this.includeCosts.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.getY() + ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeManMinutes != null) {
                ExportMealPlanProductFactSheetComponent.this.includeManMinutes.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeManMinutes.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeManMinutes.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeManMinutes.getY() + ExportMealPlanProductFactSheetComponent.this.includeManMinutes.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeProductMM != null) {
                ExportMealPlanProductFactSheetComponent.this.includeProductMM.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeProductMM.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeProductMM.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeProductMM.getY() + ExportMealPlanProductFactSheetComponent.this.includeProductMM.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeGroupMM != null) {
                ExportMealPlanProductFactSheetComponent.this.includeGroupMM.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeGroupMM.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeGroupMM.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeGroupMM.getY() + ExportMealPlanProductFactSheetComponent.this.includeGroupMM.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeComponentMM != null) {
                ExportMealPlanProductFactSheetComponent.this.includeComponentMM.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeComponentMM.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeComponentMM.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeComponentMM.getY() + ExportMealPlanProductFactSheetComponent.this.includeComponentMM.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeTender != null) {
                ExportMealPlanProductFactSheetComponent.this.includeTender.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border / 2);
                ExportMealPlanProductFactSheetComponent.this.includeTender.setSize(parent.getWidth() - 2 * ExportMealPlanProductFactSheetComponent.this.border, (int)ExportMealPlanProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                y = ExportMealPlanProductFactSheetComponent.this.includeTender.getY() + ExportMealPlanProductFactSheetComponent.this.includeTender.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border);
                ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.setSize(ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize());
                y = ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.getY() + ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.getHeight();
            }
            if (ExportMealPlanProductFactSheetComponent.this.splitCostCenters != null) {
                ExportMealPlanProductFactSheetComponent.this.splitCostCenters.setLocation(ExportMealPlanProductFactSheetComponent.this.border, y + ExportMealPlanProductFactSheetComponent.this.border);
                ExportMealPlanProductFactSheetComponent.this.splitCostCenters.setSize(ExportMealPlanProductFactSheetComponent.this.splitCostCenters.getPreferredSize());
                y = ExportMealPlanProductFactSheetComponent.this.splitCostCenters.getY() + ExportMealPlanProductFactSheetComponent.this.splitCostCenters.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportMealPlanProductFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportMealPlanProductFactSheetComponent.this.border;
            if (ExportMealPlanProductFactSheetComponent.this.dueDate != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border / 2;
            }
            if (ExportMealPlanProductFactSheetComponent.this.sep1 != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border;
            }
            if (ExportMealPlanProductFactSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border / 2;
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeCosts != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border;
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeTender != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border;
            }
            if (ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border;
            }
            if (ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                h = (int)((double)h + ExportMealPlanProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize().getHeight());
                h += ExportMealPlanProductFactSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

