/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.info.invoice;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.invoice.HistoricalInvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;

public class HistoricInvoiceDownloadComponent
extends DefaultScrollablePrintPopup2<InvoiceLight> {
    private static final long serialVersionUID = 1L;
    private Node<InvoiceLight> invoice;
    private RadioButtonBox selection;
    private TitledItem<RadioButton> ab_export;
    private TitledItem<RadioButton> ew_export;
    private TitledItem<RadioButton> sp_export;
    private TitledItem<RadioButton> report;

    public HistoricInvoiceDownloadComponent(Node<InvoiceLight> node) {
        super(false, false, false, false, null);
        this.invoice = node;
        this.selection = new RadioButtonBox();
        this.selection.setOrientation(1);
        if (((InvoiceLight)this.invoice.getValue()).getState() == InvoiceStateE.CREDIT_NOTE) {
            this.report = new TitledItem<RadioButton>(new RadioButton(), Words.CREDIT_NOTE, TitledItem.TitledItemOrientation.EAST);
            this.selection.addBox(this.report, this.report.getElement());
            this.report.getElement().setChecked(true);
        } else {
            this.ab_export = new TitledItem<RadioButton>(new RadioButton(), Words.EXCEL_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.ab_export.getElement().setChecked(true);
            this.ew_export = new TitledItem<RadioButton>(new RadioButton(), Words.DETAILED_EXCEL_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.sp_export = new TitledItem<RadioButton>(new RadioButton(), Words.SPECIAL_EXCEL_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.report = new TitledItem<RadioButton>(new RadioButton(), Words.INVOICE_SHEET, TitledItem.TitledItemOrientation.EAST);
            this.selection.addBox(this.ab_export, this.ab_export.getElement());
            this.selection.addBox(this.ew_export, this.ew_export.getElement());
            this.selection.addBox(this.sp_export, this.sp_export.getElement());
            this.selection.addBox(this.report, this.report.getElement());
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.getViewContainer().add(this.selection);
        this.setEnabled(true);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.selection != null) {
            this.selection.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.selection != null) {
            this.selection.setVisible(false);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.selection.setEnabled(isEnabled);
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE;
    }

    @Override
    public String getTitleValue() {
        if (this.invoice.getValue() != null && ((InvoiceLight)this.invoice.getValue()).getNumber() != null) {
            return ((InvoiceLight)this.invoice.getValue()).getNumber().toString();
        }
        return "-";
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InvoiceLight i = (InvoiceLight)HistoricInvoiceDownloadComponent.this.invoice.getValue();
                InvoiceComplete ic = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(i.getId())).getValue();
                HistoricalInvoiceComplete historic = ic.getFinalData();
                if (historic == null) {
                    throw new Exception(Words.NO_HISTORIC_DATA_FOUND);
                }
                PegasusFileComplete t = null;
                if (ic.getState() == InvoiceStateE.CREDIT_NOTE) {
                    if (HistoricInvoiceDownloadComponent.this.selection.getSelectedButton().equals(HistoricInvoiceDownloadComponent.this.report.getElement())) {
                        t = historic.getReport();
                    }
                } else if (HistoricInvoiceDownloadComponent.this.selection.getSelectedButton().equals(HistoricInvoiceDownloadComponent.this.report.getElement())) {
                    t = historic.getReport();
                } else if (HistoricInvoiceDownloadComponent.this.selection.getSelectedButton().equals(HistoricInvoiceDownloadComponent.this.ab_export.getElement())) {
                    t = historic.getExcelExport();
                } else if (HistoricInvoiceDownloadComponent.this.selection.getSelectedButton().equals(HistoricInvoiceDownloadComponent.this.ew_export.getElement())) {
                    t = historic.getDetailedExport();
                }
                HistoricInvoiceDownloadComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return HistoricInvoiceDownloadComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    protected boolean processFile(PegasusFileComplete reference, int cps) {
        try {
            if (this.popup != null && this.popup.isPreview()) {
                PrintPopupToolkit.previewFile(reference);
            } else {
                FileChooserUtil.saveFile(reference, reference.getFileSuffix());
            }
        }
        catch (ClientException e) {
            this.errorOccurred(e);
            return false;
        }
        catch (Exception e) {
            this.errorOccurred(new ClientException(e.getMessage(), (Throwable)e));
            return false;
        }
        return true;
    }

    @Override
    public Node<InvoiceLight> getCurrentNode() {
        return this.invoice;
    }

    @Override
    public BatchJob<InvoiceLight> createBatchJob(Node<InvoiceLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = HistoricInvoiceDownloadComponent.this.layoutInheritedComponents(parent);
            HistoricInvoiceDownloadComponent.this.selection.setLocation(HistoricInvoiceDownloadComponent.this.border, y + HistoricInvoiceDownloadComponent.this.border);
            HistoricInvoiceDownloadComponent.this.selection.setSize(parent.getWidth() - HistoricInvoiceDownloadComponent.this.border, 150);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = HistoricInvoiceDownloadComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += HistoricInvoiceDownloadComponent.this.border;
            h += HistoricInvoiceDownloadComponent.this.selection.getHeight();
            return new Dimension(w, h += HistoricInvoiceDownloadComponent.this.border);
        }
    }
}

