/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.info.matdispo;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.gui.utils.tables.MatDispoExportSheetListTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeListenerAdaptor;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class MatDispoHistoryComponent
extends ScrollablePopupInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser periodChooser;
    private MatDispoExportSheetListTable table;
    private LoadingAnimation animation;
    private NodeListenerAdaptor adaptor;

    public MatDispoHistoryComponent() {
        long oneWeek = 604800000L;
        Date startTime = new Date(System.currentTimeMillis() - oneWeek);
        Date endTime = new Date(System.currentTimeMillis());
        PeriodComplete p = new PeriodComplete(startTime, endTime);
        TimestampPeriodComplete tsp = new TimestampPeriodComplete(new Timestamp(p.getStartDate().getTime()), new Timestamp(p.getEndDate().getTime()));
        this.periodChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)tsp, false, false));
        this.table = new MatDispoExportSheetListTable();
        this.getViewContainer().setLayout(new Layout());
        this.adaptor = new NodeListenerAdaptor(){

            public void valueChanged(Node<?> node) {
                MatDispoHistoryComponent.this.reloadData();
            }
        };
        this.periodChooser.getNode().getChildNamed(TimestampPeriodComplete_.startTime).addNodeListener((NodeListener)this.adaptor);
        this.periodChooser.getNode().getChildNamed(TimestampPeriodComplete_.endTime).addNodeListener((NodeListener)this.adaptor);
        this.getViewContainer().add(this.periodChooser);
        this.getViewContainer().add(this.table);
        this.reloadData();
    }

    private void showLoadingAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.getViewContainer().add(this.animation);
            this.animation.stateChanged(Words.LOAD_DATA);
            this.animation.setVisible(true);
            this.animation.setProgress(1.0f);
        }
        this.animation.start();
        this.periodChooser.setVisible(false);
        this.table.setVisible(false);
        this.revalidate();
    }

    private void hideLoadingAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
        this.periodChooser.setVisible(true);
        this.table.setVisible(true);
    }

    public void reloadData() {
        this.showLoadingAnimation();
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                MatDispoHistoryComponent.this.periodChooser.getNode().commitThis();
                TimestampPeriodComplete tsp = MatDispoHistoryComponent.this.periodChooser.getTimePeriod();
                List res = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getMatDispoExports(tsp).getList();
                Node matNode = INodeCreator.getDefaultImpl().createNodes(res, false);
                return matNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MatDispoHistoryComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.periodChooser.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.periodChooser != null && this.periodChooser.getNode() != null) {
            this.periodChooser.getNode().getChildNamed(TimestampPeriodComplete_.startTime).removeNodeListener((NodeListener)this.adaptor);
            this.periodChooser.getNode().getChildNamed(TimestampPeriodComplete_.endTime).removeNodeListener((NodeListener)this.adaptor);
        }
        super.kill();
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.popup != null) {
            this.popup.enableCancelButton(false);
        }
        this.table.getModel().setNode(node);
        this.hideLoadingAnimation();
        super.remoteObjectLoaded(node);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)(MatDispoHistoryComponent.this.periodChooser.getPreferredSize().getHeight() + 200.0 + 30.0));
        }

        @Override
        public void layoutContainer(Container parent) {
            if (MatDispoHistoryComponent.this.animation != null) {
                MatDispoHistoryComponent.this.animation.setLocation((int)(((double)parent.getWidth() - MatDispoHistoryComponent.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - MatDispoHistoryComponent.this.animation.getPreferredSize().getHeight()) / 2);
                MatDispoHistoryComponent.this.animation.setSize(MatDispoHistoryComponent.this.animation.getPreferredSize());
            }
            MatDispoHistoryComponent.this.periodChooser.setLocation(10, 10);
            MatDispoHistoryComponent.this.periodChooser.setSize(parent.getWidth() - 20, (int)MatDispoHistoryComponent.this.periodChooser.getPreferredSize().getHeight());
            MatDispoHistoryComponent.this.table.setLocation(0, ((MatDispoHistoryComponent)MatDispoHistoryComponent.this).periodChooser.getLocation().y + ((MatDispoHistoryComponent)MatDispoHistoryComponent.this).periodChooser.getPreferredSize().height + 10);
            MatDispoHistoryComponent.this.table.setSize(parent.getWidth(), parent.getHeight() - (MatDispoHistoryComponent.this.table.getY() + 10));
        }
    }
}

