/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.popup;

import ch.icit.pegasus.client.gui.hud.externopentool.SmartExternOpenTool;
import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContent;
import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContentWithLoadBefore;
import ch.icit.pegasus.client.gui.submodules.popup.content.StyleSheetContent;
import ch.icit.pegasus.client.gui.submodules.popup.feature.SubModuleFeature;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.junit.Assert;

public abstract class DefaultSubModulePopup<RETURN_TYPE>
extends ScrollablePopupInsert {
    public static Dimension preferredSmartScreenPopupSize = new Dimension(400, 450);
    private LoadingAnimation animation;
    private MultiLineTextLabel messageLabel;
    private int border = 10;
    private int innerBorder = 5;
    private boolean previewMode;
    private SubModuleAction currentAction = SubModuleAction.INIT;
    private List<SubModulePopupContent> contentList = new ArrayList<SubModulePopupContent>();
    private List<SubModuleFeature<?>> features = new ArrayList();
    private List<Runnable> loadBeforeList = new ArrayList<Runnable>();

    public void addFeature(SubModuleFeature<?> feature) {
        this.features.add(feature);
    }

    public void showPopup(InnerPopUp2 popUp, Component parent, SmartExternOpenTool tool) {
        popUp.setView(this, tool.getBatchList());
        popUp.showPopUpWithinScreenMiddle(DefaultSubModulePopup.preferredSmartScreenPopupSize.width, DefaultSubModulePopup.preferredSmartScreenPopupSize.height, tool, parent, PopupType.NORMAL);
        this.invokeLoadBefore();
    }

    public void addContent(SubModulePopupContent content) {
        if (content instanceof SubModulePopupContentWithLoadBefore) {
            this.addLoadBefore(((SubModulePopupContentWithLoadBefore)((Object)content)).getLoadBefore());
        }
        this.contentList.add(content);
    }

    public void addLoadBefore(Runnable run) {
        this.loadBeforeList.add(run);
    }

    public void addLoadBefore(List<Runnable> run) {
        this.loadBeforeList.addAll(run);
    }

    private void invokeLoadBefore() {
        SwingUtilities.invokeLater(() -> this.runLoadBefore());
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (SubModulePopupContent subModulePopupContent : this.contentList) {
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        for (SubModulePopupContent content : this.contentList) {
            CheckedListAdder.addToList(focusList, content);
        }
        return focusList;
    }

    private void showContent() {
        this.currentAction = SubModuleAction.WAIT_FOR_USER;
        for (SubModulePopupContent content : this.contentList) {
            this.getViewContainer().add(content);
            content.fadeIn();
        }
    }

    private void runLoadBefore() {
        this.currentAction = SubModuleAction.LOAD_BEFORE;
        if (this.loadBeforeList.isEmpty()) {
            return;
        }
        this.showAnimation(this.getLoadBeforeText());
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                for (Runnable runnable : DefaultSubModulePopup.this.loadBeforeList) {
                    runnable.run();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        for (SubModulePopupContent content : DefaultSubModulePopup.this.contentList) {
                            if (!(content instanceof SubModulePopupContentWithLoadBefore)) continue;
                            ((SubModulePopupContentWithLoadBefore)((Object)content)).processAfterLoadBeforeInSync();
                        }
                        DefaultSubModulePopup.this.hideAnimation();
                        DefaultSubModulePopup.this.showContent();
                    }

                    public void errorOccurred(ClientException exception) {
                        DefaultSubModulePopup.this.hideAnimation();
                        DefaultSubModulePopup.this.configureFinished(false, exception.getMessage());
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void configureFinished(boolean success, String additionalMessage) {
        this.currentAction = SubModuleAction.DONE;
        String message = success ? this.getSuccessfulText() : this.getErrorText() + additionalMessage;
        this.showMessage(message);
        this.popup.hideCancelButton();
    }

    protected void install() {
        this.getViewContainer().setLayout(new Layout());
    }

    public String getLoadBeforeText() {
        return Words.LOAD_DATA;
    }

    public String getProcessText() {
        return Words.PROCESS;
    }

    public String getSuccessfulText() {
        return Words.SUCCESSFUL;
    }

    public String getErrorText() {
        return Words.FAILED + ": ";
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        switch (this.currentAction) {
            case WAIT_FOR_USER: {
                this.enterPressedFormWaitForUser(isOK);
                break;
            }
            case PROCESSING: 
            case INIT: 
            case LOAD_BEFORE: {
                break;
            }
            case DONE: {
                this.enterPressFromDone(isOK);
            }
        }
    }

    private void enterPressFromDone(PopupAction isOK) {
        this.popup.hidePopUp(new Object[0]);
    }

    private void enterPressedFormWaitForUser(PopupAction isOK) {
        if (this.validateContent()) {
            switch (isOK) {
                case PREVIEW: {
                    this.startProcess(true);
                    break;
                }
                case OK_FOREGROUND: {
                    this.startProcess(false);
                    break;
                }
                case OK_BACKGROUND: {
                    this.startProcess(false);
                    break;
                }
                case CANCEL: {
                    this.popup.hidePopUp(new Object[0]);
                }
            }
            this.popup.hidePopUp(this.getValues(isOK));
        }
    }

    private void startProcess(boolean previewMode) {
        this.previewMode = previewMode;
        this.currentAction = SubModuleAction.PROCESSING;
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                Node<?> returnValue = DefaultSubModulePopup.this.getJob().loadData();
                return DefaultSubModulePopup.this.processReturnValueInExecutionThread(returnValue);
            }

            @Override
            public RemoteLoader getInvoker() {
                return DefaultSubModulePopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.currentAction = SubModuleAction.DONE;
        this.hideAnimation();
        Assert.assertTrue((String)"Node is null", (node != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Node Value is null", (node.getValue() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Node Vales is not instance of AsyncReturn", (boolean)(node.getValue() instanceof AsyncReturn));
        Node<?> valueNode = node;
        switch (((AsyncReturn)valueNode.getValue()).getState()) {
            case Ok: {
                this.showMessage(this.getSuccessfulText());
                this.processReturnValueInUIThread((AsyncReturn)valueNode.getValue());
                break;
            }
            case Error: {
                this.configureFinished(false, ((AsyncReturn)valueNode.getValue()).getMessage());
            }
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.showMessage(this.getErrorText() + exception.getMessage());
    }

    private void processReturnValueInUIThread(AsyncReturn<RETURN_TYPE> value) {
        Assert.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
        this.processReturnInSync(value);
    }

    private Node<AsyncReturn<RETURN_TYPE>> processReturnValueInExecutionThread(Node<?> node) {
        Assert.assertTrue((!SwingUtilities.isEventDispatchThread() ? 1 : 0) != 0);
        return this.processReturnASync(node);
    }

    protected abstract void processReturnInSync(AsyncReturn<RETURN_TYPE> var1);

    protected abstract Node<AsyncReturn<RETURN_TYPE>> processReturnASync(Node<?> var1);

    protected void showMessage(String message) {
        if (this.messageLabel == null) {
            this.messageLabel = new MultiLineTextLabel();
            this.getViewContainer().add(this.messageLabel);
        }
        this.messageLabel.setText(message);
        this.getViewContainer().revalidate();
    }

    protected void hideMessage() {
        if (this.messageLabel != null) {
            this.messageLabel.fadeOut(true);
            this.messageLabel = null;
        }
    }

    protected void hideAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(true);
            this.animation = null;
        }
    }

    protected void showAnimation(String postFix) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.start();
            this.getViewContainer().add(this.animation);
            this.animation.fadeIn();
        }
        this.animation.stateChanged(this.getProcessText() + postFix);
        this.getViewContainer().revalidate();
    }

    public ReportFileComplete getSelectedReport() {
        for (SubModulePopupContent content : this.contentList) {
            if (!(content instanceof StyleSheetContent)) continue;
            return ((StyleSheetContent)content).getSelectedReport();
        }
        return null;
    }

    public abstract ThreadSafeExecutable getJob();

    public static class AsyncReturn<T> {
        private ReturnState state;
        private String message;
        private T value;

        public AsyncReturn(T value, ReturnState state, String message) {
            this.value = value;
            this.state = state;
            this.message = message;
        }

        public ReturnState getState() {
            return this.state;
        }

        public T getValue() {
            return this.value;
        }

        public String getMessage() {
            return this.message;
        }

        static enum ReturnState {
            Ok,
            Error;

        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h;
            int w;
            if (DefaultSubModulePopup.this.animation != null) {
                w = (int)DefaultSubModulePopup.this.animation.getPreferredSize().getWidth();
                h = (int)DefaultSubModulePopup.this.animation.getPreferredSize().getHeight();
            } else if (DefaultSubModulePopup.this.messageLabel != null) {
                w = (int)DefaultSubModulePopup.this.messageLabel.getPreferredSize().getWidth();
                h = (int)DefaultSubModulePopup.this.messageLabel.getPreferredSize().getHeight();
            } else {
                int y = DefaultSubModulePopup.this.border;
                for (SubModulePopupContent content : DefaultSubModulePopup.this.contentList) {
                    y = (int)((double)y + content.getPreferredSize().getHeight());
                    y += DefaultSubModulePopup.this.innerBorder;
                }
                if (!DefaultSubModulePopup.this.contentList.isEmpty()) {
                    y -= DefaultSubModulePopup.this.innerBorder;
                }
                w = 0;
                h = y += DefaultSubModulePopup.this.border;
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (DefaultSubModulePopup.this.animation != null) {
                DefaultSubModulePopup.this.animation.setLocation((int)((double)parent.getWidth() - DefaultSubModulePopup.this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - DefaultSubModulePopup.this.animation.getPreferredSize().getHeight()) / 2.0));
                DefaultSubModulePopup.this.animation.setSize(DefaultSubModulePopup.this.animation.getPreferredSize());
            } else if (DefaultSubModulePopup.this.messageLabel != null) {
                DefaultSubModulePopup.this.messageLabel.setLocation(DefaultSubModulePopup.this.border, DefaultSubModulePopup.this.border);
                DefaultSubModulePopup.this.messageLabel.setSize(parent.getWidth() - 2 * DefaultSubModulePopup.this.border, (int)DefaultSubModulePopup.this.messageLabel.getPreferredSize().getHeight());
            } else {
                int y = DefaultSubModulePopup.this.border;
                for (SubModulePopupContent content : DefaultSubModulePopup.this.contentList) {
                    content.setLocation(DefaultSubModulePopup.this.border, y);
                    content.setSize(parent.getWidth() - 2 * DefaultSubModulePopup.this.border, (int)content.getPreferredSize().getHeight());
                    y += content.getHeight() + DefaultSubModulePopup.this.innerBorder;
                }
            }
        }
    }

    static enum SubModuleAction {
        INIT,
        LOAD_BEFORE,
        WAIT_FOR_USER,
        PROCESSING,
        DONE;

    }
}

